/* THIS FILE IS AUTOGENERATED FROM XMLHttpRequest.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_XMLHttpRequestBinding_h
#define mozilla_dom_XMLHttpRequestBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "js/Value.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Blob;
class Document;
class FormData;
struct MozXMLHttpRequestParametersAtoms;
struct NativePropertyHooks;
class OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString;
class ProtoAndIfaceCache;
class URLSearchParams;
class XMLHttpRequest;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class XMLHttpRequestResponseType : uint8_t {
  _empty,
  Arraybuffer,
  Blob,
  Document,
  Json,
  Text,
  EndGuard_
};

namespace XMLHttpRequestResponseTypeValues {
extern const EnumEntry strings[7];

static constexpr size_t Count = 6;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(XMLHttpRequestResponseType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(XMLHttpRequestResponseType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace XMLHttpRequestResponseTypeValues

bool
ToJSValue(JSContext* aCx, XMLHttpRequestResponseType aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString& aUnion);


class DocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString
{
  enum TypeOrUninit
  {
    eUninitialized,
    eDocument,
    eBlob,
    eArrayBufferView,
    eArrayBuffer,
    eFormData,
    eURLSearchParams,
    eUSVString
  };
public:
  enum class Type
  {
    eDocument = TypeOrUninit::eDocument,
    eBlob = TypeOrUninit::eBlob,
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eFormData = TypeOrUninit::eFormData,
    eURLSearchParams = TypeOrUninit::eURLSearchParams,
    eUSVString = TypeOrUninit::eUSVString
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::Document> > mDocument;
    UnionMember<NonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBufferView> > mArrayBufferView;
    UnionMember<RootedSpiderMonkeyInterface<ArrayBuffer> > mArrayBuffer;
    UnionMember<NonNull<mozilla::dom::FormData> > mFormData;
    UnionMember<NonNull<mozilla::dom::URLSearchParams> > mURLSearchParams;
    UnionMember<binding_detail::FakeString<char16_t> > mUSVString;

  };

  TypeOrUninit mType;
  Value mValue;

  DocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString(const DocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString&) = delete;
  DocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString& operator=(const DocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString&) = delete;
public:
  explicit inline DocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString()
    : mType(eUninitialized)
  {
  }

  inline ~DocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString()
  {
    Uninit();
  }

  inline NonNull<mozilla::dom::Document>&
  RawSetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline NonNull<mozilla::dom::Document>&
  SetAsDocument()
  {
    if (mType == eDocument) {
      return mValue.mDocument.Value();
    }
    Uninit();
    mType = eDocument;
    return mValue.mDocument.SetValue();
  }

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline NonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline mozilla::dom::Document&
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline NonNull<mozilla::dom::Blob>&
  RawSetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline NonNull<mozilla::dom::Blob>&
  SetAsBlob()
  {
    if (mType == eBlob) {
      return mValue.mBlob.Value();
    }
    Uninit();
    mType = eBlob;
    return mValue.mBlob.SetValue();
  }

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline NonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline mozilla::dom::Blob&
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  RawSetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  SetAsArrayBufferView(JSContext* cx)
  {
    if (mType == eArrayBufferView) {
      return mValue.mArrayBufferView.Value();
    }
    Uninit();
    mType = eArrayBufferView;
    return mValue.mArrayBufferView.SetValue(cx);
  }

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline RootedSpiderMonkeyInterface<ArrayBufferView>&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  RawSetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  SetAsArrayBuffer(JSContext* cx)
  {
    if (mType == eArrayBuffer) {
      return mValue.mArrayBuffer.Value();
    }
    Uninit();
    mType = eArrayBuffer;
    return mValue.mArrayBuffer.SetValue(cx);
  }

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline RootedSpiderMonkeyInterface<ArrayBuffer>&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline NonNull<mozilla::dom::FormData>&
  RawSetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  inline NonNull<mozilla::dom::FormData>&
  SetAsFormData()
  {
    if (mType == eFormData) {
      return mValue.mFormData.Value();
    }
    Uninit();
    mType = eFormData;
    return mValue.mFormData.SetValue();
  }

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline NonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline mozilla::dom::FormData&
  GetAsFormData() const
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline NonNull<mozilla::dom::URLSearchParams>&
  RawSetAsURLSearchParams()
  {
    if (mType == eURLSearchParams) {
      return mValue.mURLSearchParams.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eURLSearchParams;
    return mValue.mURLSearchParams.SetValue();
  }

  inline NonNull<mozilla::dom::URLSearchParams>&
  SetAsURLSearchParams()
  {
    if (mType == eURLSearchParams) {
      return mValue.mURLSearchParams.Value();
    }
    Uninit();
    mType = eURLSearchParams;
    return mValue.mURLSearchParams.SetValue();
  }

  inline bool
  IsURLSearchParams() const
  {
    return mType == eURLSearchParams;
  }

  inline NonNull<mozilla::dom::URLSearchParams>&
  GetAsURLSearchParams()
  {
    MOZ_RELEASE_ASSERT(IsURLSearchParams(), "Wrong type!");
    return mValue.mURLSearchParams.Value();
  }

  inline mozilla::dom::URLSearchParams&
  GetAsURLSearchParams() const
  {
    MOZ_RELEASE_ASSERT(IsURLSearchParams(), "Wrong type!");
    return mValue.mURLSearchParams.Value();
  }

  inline binding_detail::FakeString<char16_t>&
  RawSetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  inline binding_detail::FakeString<char16_t>&
  SetAsUSVString()
  {
    if (mType == eUSVString) {
      return mValue.mUSVString.Value();
    }
    Uninit();
    mType = eUSVString;
    return mValue.mUSVString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline const nsAString&
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eDocument: {
        DestroyDocument();
        break;
      }
      case eBlob: {
        DestroyBlob();
        break;
      }
      case eArrayBufferView: {
        DestroyArrayBufferView();
        break;
      }
      case eArrayBuffer: {
        DestroyArrayBuffer();
        break;
      }
      case eFormData: {
        DestroyFormData();
        break;
      }
      case eURLSearchParams: {
        DestroyURLSearchParams();
        break;
      }
      case eUSVString: {
        DestroyUSVString();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    mValue.mDocument.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    mValue.mBlob.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    mValue.mArrayBufferView.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    mValue.mArrayBuffer.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToFormData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFormData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    mValue.mFormData.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToURLSearchParams(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToURLSearchParams(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyURLSearchParams()
  {
    MOZ_RELEASE_ASSERT(IsURLSearchParams(), "Wrong type!");
    mValue.mURLSearchParams.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    mValue.mUSVString.Destroy();
    mType = eUninitialized;
  }
};


class OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eDocument,
    eBlob,
    eArrayBufferView,
    eArrayBuffer,
    eFormData,
    eURLSearchParams,
    eUSVString
  };
public:
  enum class Type
  {
    eDocument = TypeOrUninit::eDocument,
    eBlob = TypeOrUninit::eBlob,
    eArrayBufferView = TypeOrUninit::eArrayBufferView,
    eArrayBuffer = TypeOrUninit::eArrayBuffer,
    eFormData = TypeOrUninit::eFormData,
    eURLSearchParams = TypeOrUninit::eURLSearchParams,
    eUSVString = TypeOrUninit::eUSVString
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::Document> > mDocument;
    UnionMember<OwningNonNull<mozilla::dom::Blob> > mBlob;
    UnionMember<ArrayBufferView > mArrayBufferView;
    UnionMember<ArrayBuffer > mArrayBuffer;
    UnionMember<OwningNonNull<mozilla::dom::FormData> > mFormData;
    UnionMember<OwningNonNull<mozilla::dom::URLSearchParams> > mURLSearchParams;
    UnionMember<nsString > mUSVString;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString(const OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString&) = delete;
  OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString& operator=(const OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString&) = delete;
public:
  explicit inline OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString()
    : mType(eUninitialized)
  {
  }

  OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString(OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString&& aOther);

  inline ~OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString()
  {
    Uninit();
  }

  OwningNonNull<mozilla::dom::Document>&
  RawSetAsDocument();

  OwningNonNull<mozilla::dom::Document>&
  SetAsDocument();

  inline bool
  IsDocument() const
  {
    return mType == eDocument;
  }

  inline OwningNonNull<mozilla::dom::Document>&
  GetAsDocument()
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  inline OwningNonNull<mozilla::dom::Document> const &
  GetAsDocument() const
  {
    MOZ_RELEASE_ASSERT(IsDocument(), "Wrong type!");
    return mValue.mDocument.Value();
  }

  OwningNonNull<mozilla::dom::Blob>&
  RawSetAsBlob();

  OwningNonNull<mozilla::dom::Blob>&
  SetAsBlob();

  inline bool
  IsBlob() const
  {
    return mType == eBlob;
  }

  inline OwningNonNull<mozilla::dom::Blob>&
  GetAsBlob()
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  inline OwningNonNull<mozilla::dom::Blob> const &
  GetAsBlob() const
  {
    MOZ_RELEASE_ASSERT(IsBlob(), "Wrong type!");
    return mValue.mBlob.Value();
  }

  ArrayBufferView&
  RawSetAsArrayBufferView();

  ArrayBufferView&
  SetAsArrayBufferView();

  inline bool
  IsArrayBufferView() const
  {
    return mType == eArrayBufferView;
  }

  inline ArrayBufferView&
  GetAsArrayBufferView()
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  inline ArrayBufferView const &
  GetAsArrayBufferView() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBufferView(), "Wrong type!");
    return mValue.mArrayBufferView.Value();
  }

  ArrayBuffer&
  RawSetAsArrayBuffer();

  ArrayBuffer&
  SetAsArrayBuffer();

  inline bool
  IsArrayBuffer() const
  {
    return mType == eArrayBuffer;
  }

  inline ArrayBuffer&
  GetAsArrayBuffer()
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  inline ArrayBuffer const &
  GetAsArrayBuffer() const
  {
    MOZ_RELEASE_ASSERT(IsArrayBuffer(), "Wrong type!");
    return mValue.mArrayBuffer.Value();
  }

  OwningNonNull<mozilla::dom::FormData>&
  RawSetAsFormData();

  OwningNonNull<mozilla::dom::FormData>&
  SetAsFormData();

  inline bool
  IsFormData() const
  {
    return mType == eFormData;
  }

  inline OwningNonNull<mozilla::dom::FormData>&
  GetAsFormData()
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  inline OwningNonNull<mozilla::dom::FormData> const &
  GetAsFormData() const
  {
    MOZ_RELEASE_ASSERT(IsFormData(), "Wrong type!");
    return mValue.mFormData.Value();
  }

  OwningNonNull<mozilla::dom::URLSearchParams>&
  RawSetAsURLSearchParams();

  OwningNonNull<mozilla::dom::URLSearchParams>&
  SetAsURLSearchParams();

  inline bool
  IsURLSearchParams() const
  {
    return mType == eURLSearchParams;
  }

  inline OwningNonNull<mozilla::dom::URLSearchParams>&
  GetAsURLSearchParams()
  {
    MOZ_RELEASE_ASSERT(IsURLSearchParams(), "Wrong type!");
    return mValue.mURLSearchParams.Value();
  }

  inline OwningNonNull<mozilla::dom::URLSearchParams> const &
  GetAsURLSearchParams() const
  {
    MOZ_RELEASE_ASSERT(IsURLSearchParams(), "Wrong type!");
    return mValue.mURLSearchParams.Value();
  }

  nsString&
  RawSetAsUSVString();

  nsString&
  SetAsUSVString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsUSVString().AssignLiteral(aData);
  }

  inline bool
  IsUSVString() const
  {
    return mType == eUSVString;
  }

  inline nsString&
  GetAsUSVString()
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  inline nsString const &
  GetAsUSVString() const
  {
    MOZ_RELEASE_ASSERT(IsUSVString(), "Wrong type!");
    return mValue.mUSVString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString&
  operator=(OwningDocumentOrBlobOrArrayBufferViewOrArrayBufferOrFormDataOrURLSearchParamsOrUSVString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToDocument(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToDocument(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyDocument();

  bool
  TrySetToBlob(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToBlob(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBlob();

  bool
  TrySetToArrayBufferView(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBufferView(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBufferView();

  bool
  TrySetToArrayBuffer(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToArrayBuffer(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyArrayBuffer();

  bool
  TrySetToFormData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToFormData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyFormData();

  bool
  TrySetToURLSearchParams(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToURLSearchParams(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyURLSearchParams();

  bool
  TrySetToUSVString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUSVString();
};


struct MozXMLHttpRequestParameters : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mMozAnon;
  MOZ_INIT_OUTSIDE_CTOR bool mMozSystem;

  MozXMLHttpRequestParameters();

  explicit inline MozXMLHttpRequestParameters(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MozXMLHttpRequestParameters(MozXMLHttpRequestParameters&& aOther) = default;

  explicit inline MozXMLHttpRequestParameters(const MozXMLHttpRequestParameters& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MozXMLHttpRequestParameters&
  operator=(const MozXMLHttpRequestParameters& aOther);

  bool
  operator==(const MozXMLHttpRequestParameters& aOther) const;

private:
  static bool
  InitIds(JSContext* cx, MozXMLHttpRequestParametersAtoms* atomsCache);
};

namespace binding_detail {
struct FastMozXMLHttpRequestParameters : public MozXMLHttpRequestParameters
{
  inline FastMozXMLHttpRequestParameters()
    : MozXMLHttpRequestParameters(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace XMLHttpRequest_Binding {

  typedef mozilla::dom::XMLHttpRequest NativeType;

  static const uint16_t UNSENT = 0;
  static const uint16_t OPENED = 1;
  static const uint16_t HEADERS_RECEIVED = 2;
  static const uint16_t LOADING = 3;
  static const uint16_t DONE = 4;
  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::XMLHttpRequest* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedResponseTextValue(mozilla::dom::XMLHttpRequest* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::XMLHttpRequest,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::XMLHttpRequest,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::XMLHttpRequest,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace XMLHttpRequest_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_XMLHttpRequestBinding_h
