// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_Metrics_h
#define mozilla_Metrics_h

#include "mozilla/glean/bindings/MetricTypes.h"
#include "mozilla/Maybe.h"
#include "nsTArray.h"
#include "nsPrintfCString.h"

#include <tuple>

namespace mozilla::glean {
struct NoExtraKeys;
enum class DynamicLabel: uint16_t { };

namespace background_update {
  /**
   * generated from background_update.reasons_to_not_update
   */
  /**
   * Records which error was causing the background updater to fail. This list
     * supercedes the `background-update.reason` in `mozapps/update/metrics.yaml`
   */
  constexpr impl::StringListMetric reasons_to_not_update(1);

  /**
   * generated from background_update.time_last_update_scheduled
   */
  /**
   * Last time the background update was triggered.
   */
  constexpr impl::DatetimeMetric time_last_update_scheduled(2);

  /**
   * generated from background_update.client_id
   */
  /**
   * The legacy Telemetry client ID of this installation's default profile.
     * The default profile is as determined by the Profile Service, namely
     * `nsIToolkitProfileService.defaultProfile`.  The majority of users have only one
     * Firefox installation and only one profile, so the default profile is their
     * regular browsing profile.
     * It is possible for a Firefox installation to not have a default profile, but in
     * such cases the background update task will abort before sending any telemetry;
     * therefore, the legacy Telemetry client ID should always be present.
   */
  constexpr impl::UuidMetric client_id(3);

  /**
   * generated from background_update.exit_code_exception
   */
  /**
   * True if the exit code/status of the background update task is 3, which means an
     * exception was thrown.
   */
  constexpr impl::BooleanMetric exit_code_exception(4);

  /**
   * generated from background_update.exit_code_success
   */
  /**
   * True if the exit code/status of the background update task is 0, which means
     * success.
   */
  constexpr impl::BooleanMetric exit_code_success(5);

  /**
   * generated from background_update.final_state
   */
  /**
   * String description of the final state the update state machine reached.
   */
  constexpr impl::StringMetric final_state(6);

  /**
   * generated from background_update.reasons
   */
  /**
   * List of reasons that the background update task did not run.
   */
  constexpr impl::StringListMetric reasons(7);

  /**
   * generated from background_update.states
   */
  /**
   * Ordered list of string descriptions of the states that the update state machine
     * reached.
   */
  constexpr impl::StringListMetric states(8);

  /**
   * generated from background_update.targeting_env_current_date
   */
  /**
   * The `environment.currentDate` of the default profile's serialized targeting
     * snapshot.
   */
  constexpr impl::DatetimeMetric targeting_env_current_date(9);

  /**
   * generated from background_update.targeting_env_firefox_version
   */
  /**
   * The `environment.firefoxVersion` of the default profile's serialized targeting
     * snapshot.  At the time of writing, this version is an integer representing the
     * Firefox major version, e.g., `109`.
   */
  constexpr impl::QuantityMetric targeting_env_firefox_version(10);

  /**
   * generated from background_update.targeting_env_profile_age
   */
  /**
   * The `environment.profileAgeCreated` of the default profile's serialized
     * targeting snapshot.
   */
  constexpr impl::DatetimeMetric targeting_env_profile_age(11);

  /**
   * generated from background_update.targeting_exception
   */
  /**
   * True if the default profile had a targeting snapshot serialized to disk, but an
     * exception was thrown reading it.
   */
  constexpr impl::BooleanMetric targeting_exception(12);

  /**
   * generated from background_update.targeting_exists
   */
  /**
   * True if the default profile had a targeting snapshot serialized to disk, and
     * there was no exception thrown reading it.
   */
  constexpr impl::BooleanMetric targeting_exists(13);

  /**
   * generated from background_update.targeting_version
   */
  /**
   * If the default profile had a targeting snapshot serialized to disk, the
     * `version` of the snapshot.
     * This version number does not have a physical unit: it's only useful to compare
     * between versions.
   */
  constexpr impl::QuantityMetric targeting_version(14);

}
namespace browser_launched_to_handle {
  /**
   * generated from browser.launched_to_handle.system_notification
   */
    struct SystemNotificationExtra {
      mozilla::Maybe<nsCString> action;
      mozilla::Maybe<nsCString> name;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        if (name) {
          extraKeys.AppendElement()->AssignASCII("name");
          extraValues.EmplaceBack(name.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when Firefox launches to complete a native notification popped by a
     * system (chrome privileged) alert.  Windows-only at the time of writing.
   */
  constexpr impl::EventMetric<SystemNotificationExtra> system_notification(15);

}
namespace messaging_system {
  /**
   * generated from messaging_system.action
   */
  /**
   * What type of action resulted in the event. One of "IMPRESSION" or "DISMISS".
   */
  constexpr impl::StringMetric action(16);

  /**
   * generated from messaging_system.addon_version
   */
  /**
   * Used to hold the system addon's version, now is almost certainly an echo of the
     * app's build id.
   */
  constexpr impl::StringMetric addon_version(17);

  /**
   * generated from messaging_system.browser_session_id
   */
  /**
   * The Legacy Telemetry browser "session id". Identifies a specific period from
     * application start to shutdown. See [the "main" ping docs](https://firefox-
     * source-docs.mozilla.org/toolkit/components/telemetry/data/main-ping.html) for
     * details.
   */
  constexpr impl::UuidMetric browser_session_id(18);

  /**
   * generated from messaging_system.bucket_id
   */
  /**
   * A name shared between multiple messages that may individually be too targetted.
     * e.g. a message that gets shown on specific websites or a message asking about
     * personal information.
   */
  constexpr impl::StringMetric bucket_id(19);

  /**
   * generated from messaging_system.cfr_action
   */
  /**
   * The Contextual Feature Recommender's action.
   */
  constexpr impl::TextMetric cfr_action(20);

  /**
   * generated from messaging_system.client_id
   */
  /**
   * The client_id according to Telemetry.
     * Might not always have a value due to policy around specific types of
     * ping being sent. Value may be the canary client id
     * `c0ffeec0-ffee-c0ff-eec0-ffeec0ffeec0`
     * in pings near when the data upload pref is disabled (if Telemetry gets
     * to go first), or between when a client_id has been removed and when it
     * has been regenerated.
     * Present only in some circumstances (see
     * [bug 1484035]https://bugzilla.mozilla.org/show_bug.cgi?id=1484035)).
   */
  constexpr impl::UuidMetric client_id(21);

  /**
   * generated from messaging_system.event
   */
  /**
   * The type of event. Any user defined string (e.g. “click”, “share”, “delete”,
     * “more_items”)
   */
  constexpr impl::StringMetric event(22);

  /**
   * generated from messaging_system.event_context
   */
  /**
   * The stringified JSON of `event_context`.
   */
  constexpr impl::TextMetric event_context(23);

  /**
   * generated from messaging_system.event_context_parse_error
   */
  /**
   * How often we failed to parse event_context as JSON.
   */
  constexpr impl::CounterMetric event_context_parse_error(24);

  /**
   * generated from messaging_system.event_page
   */
  /**
   * The event_context's `page`. Almost always "about:welcome".
   */
  constexpr impl::StringMetric event_page(25);

  /**
   * generated from messaging_system.event_reason
   */
  /**
   * The event_context's `reason`. Likely something like
     * "welcome-window-closed" or "app-shut-down",.
   */
  constexpr impl::StringMetric event_reason(26);

  /**
   * generated from messaging_system.event_source
   */
  /**
   * The event_context's `source`. Likely something like "primary_button".
   */
  constexpr impl::StringMetric event_source(27);

  /**
   * generated from messaging_system.glean_ping_for_ping_failures
   */
  /**
   * How often something went awry within
     * `AboutWelcome.submitGleanPingForPing`, preventing ping submission.
   */
  constexpr impl::CounterMetric glean_ping_for_ping_failures(28);

  /**
   * generated from messaging_system.impression_id
   */
  /**
   * The unique impression identifier for a specific client.
   */
  constexpr impl::UuidMetric impression_id(29);

  /**
   * generated from messaging_system.invalid_nested_data
   */
  /**
   * We received a ping with non-scalar data on a field of this name.
     * If this is existing pre-PingCentre-replacement data, you may need to
     * augment the logic in
     * `AboutWelcome.submitGleanPingForPing` like the other `handledKeys`.
     * If this is for new, post-PingCentre-replacement data, you should
     * probably prefer a flat structure.
     * If you're unsure, please ask in
     * [the #glean channel](https://chat.mozilla.org/#/room/#glean:mozilla.org).
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> invalid_nested_data(30);

  /**
   * generated from messaging_system.locale
   */
  /**
   * The locale as supplied to the messaging system by
     * `Services.locale.appLocaleAsBCP47`.
   */
  constexpr impl::StringMetric locale(31);

  /**
   * generated from messaging_system.message_id
   */
  /**
   * A string identifier of the message in Activity Stream Router.
   */
  constexpr impl::TextMetric message_id(32);

  /**
   * generated from messaging_system.page
   */
  /**
   * One of [”about:newtab”, “about:home”, “about:welcome”, “unknown” (which either
     * means not-applicable or is a bug)].
   */
  constexpr impl::StringMetric page(33);

  /**
   * generated from messaging_system.ping_type
   */
  /**
   * Type of event the ping is capturing. e.g. "cfr", "whats-new-panel",
     * "onboarding"
   */
  constexpr impl::StringMetric ping_type(34);

  /**
   * generated from messaging_system.source
   */
  /**
   * The source of the interaction described by the other metrics. e.g.
     * "frecent_links", "newtab", "CFR"
   */
  constexpr impl::StringMetric source(35);

  /**
   * generated from messaging_system.unknown_key_count
   */
  /**
   * The sum of all unknown keys counted.
     * Useful for testing.
     * Can be removed after bug 1600008 is resolved.
   */
  constexpr impl::CounterMetric unknown_key_count(36);

  /**
   * generated from messaging_system.unknown_keys
   */
  /**
   * Ping keys supplied to the messaging system for which
     * we did not have a corresponding metric mapped to how often they attempted
     * to be recorded.
     * You may have forgotten to define an appropriate metric in
     * `browser/components/newtab/metrics.yaml`.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> unknown_keys(37);

}
namespace messaging_system_attribution {
  /**
   * generated from messaging_system.attribution.campaign
   */
  /**
   * Attribution's campaign, possibly derived from the utm parameter of the
     * same name.
   */
  constexpr impl::StringMetric campaign(38);

  /**
   * generated from messaging_system.attribution.content
   */
  /**
   * Attribution's content, possibly derived from the utm parameter of the
     * same name.
   */
  constexpr impl::StringMetric content(39);

  /**
   * generated from messaging_system.attribution.dlsource
   */
  /**
   * Mozilla-specific download "source" name. Could be something like
     * "mozillaci" to identify that the installer came from
     * `{archive|ftp}.mozilla.org`.
   */
  constexpr impl::StringMetric dlsource(40);

  /**
   * generated from messaging_system.attribution.dltoken
   */
  /**
   * String representation of the dltoken identifying the particular
     * installer used to install this Firefox.
     * Likely a UUID, if present.
   */
  constexpr impl::StringMetric dltoken(41);

  /**
   * generated from messaging_system.attribution.experiment
   */
  /**
   * Attribution's experiment key.
   */
  constexpr impl::StringMetric experiment(42);

  /**
   * generated from messaging_system.attribution.medium
   */
  /**
   * Attribution's medium, possibly derived from the utm parameter of the same
     * name.
   */
  constexpr impl::StringMetric medium(43);

  /**
   * generated from messaging_system.attribution.msstoresignedin
   */
  /**
   * Either the string "true" or the string "false" to indicate whether the
     * attributed install came from the Microsoft store and, if so, whether the
     * user was signed in at the time.
   */
  constexpr impl::StringMetric msstoresignedin(44);

  /**
   * generated from messaging_system.attribution.source
   */
  /**
   * Attribution's source, possibly derived from the utm parameter of the same
     * name.
   */
  constexpr impl::StringMetric source(45);

  /**
   * generated from messaging_system.attribution.ua
   */
  /**
   * Attribution's ua key.
   */
  constexpr impl::StringMetric ua(46);

  /**
   * generated from messaging_system.attribution.unknown_keys
   */
  /**
   * Attribution keys supplied to the messaging system for which
     * we did not have a corresponding metric, and the count of how
     * often that happened.
     * Either add this key to a list of known attribution keys in
     * `AboutWelcomeTelemetry` to suppress or define an appropriate metric in
     * `browser/components/newtab/metrics.yaml` to collect.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> unknown_keys(47);

  /**
   * generated from messaging_system.attribution.variation
   */
  /**
   * Attribution's variation key.
   */
  constexpr impl::StringMetric variation(48);

}
namespace newtab {
  /**
   * generated from newtab.blocked_sponsors
   */
  /**
   * The advertiser names that have been dismissed by the user.
   */
  constexpr impl::StringListMetric blocked_sponsors(49);

  /**
   * generated from newtab.closed
   */
    struct ClosedExtra {
      mozilla::Maybe<nsCString> newtabVisitId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when newtab UI is closed by * navigation * closing the tab
     * Doesn't mean that the newtab was ever visible to a user.
   */
  constexpr impl::EventMetric<ClosedExtra> closed(50);

  /**
   * generated from newtab.homepage_category
   */
  /**
   * The current setting of the home page. One of ["enabled", "disabled",
     * "extension"] or any value from SiteClassifier like "known-hijacker" or "social-
     * media". Similar to Activity Stream's PAGE_TAKEOVER_DATA event's
     * `home_url_category`. Sampled once after newtab init.
   */
  constexpr impl::StringMetric homepage_category(51);

  /**
   * generated from newtab.locale
   */
  /**
   * The application's locale as of when newtab's TelemetryFeed was init. Comes from
     * `Services.local.appLocaleAsBCP47`. Looks like `en-US`.
   */
  constexpr impl::StringMetric locale(52);

  /**
   * generated from newtab.newtab_category
   */
  /**
   * The current setting of the newtab page. One of ["enabled", "disabled",
     * "extension"] or any value from SiteClassifier like "known-hijacker" or "social-
     * media". Similar to Activity Stream's PAGE_TAKEOVER_DATA event's
     * `newtab_url_category`. Sampled once after newtab init.
   */
  constexpr impl::StringMetric newtab_category(53);

  /**
   * generated from newtab.opened
   */
    struct OpenedExtra {
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> source;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (source) {
          extraKeys.AppendElement()->AssignASCII("source");
          extraValues.EmplaceBack(source.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when newtab UI is opened via `about:newtab` or `about:home` or
     * `about:welcome` and has been made visible (see `visibility_event_rcvd_ts` in
     * [detect-user-session-start.js](https://searchfox.org/mozilla-
     * central/source/browser/components/newtab/content-src/lib/detect-user-session-
     * start.js)).
   */
  constexpr impl::EventMetric<OpenedExtra> opened(54);

}
namespace newtab_search {
  /**
   * generated from newtab.search.enabled
   */
  /**
   * Whether the search input is enabled on the newtab. Corresponds to the value of
     * the `browser.newtabpage.activity-stream.showSearch` pref.
   */
  constexpr impl::BooleanMetric enabled(55);

  /**
   * generated from newtab.search.issued
   */
    struct IssuedExtra {
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> searchAccessPoint;
      mozilla::Maybe<nsCString> telemetryId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (searchAccessPoint) {
          extraKeys.AppendElement()->AssignASCII("search_access_point");
          extraValues.EmplaceBack(searchAccessPoint.value());
        }
        if (telemetryId) {
          extraKeys.AppendElement()->AssignASCII("telemetry_id");
          extraValues.EmplaceBack(telemetryId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * When Firefox was asked to issue a search from a Search Access Point (SAP) on a
     * newtab page. Doesn't record searches in Private Browsing Mode unless
     * `browser.engagement.search_counts.pbm` is set to `true`.
   */
  constexpr impl::EventMetric<IssuedExtra> issued(56);

}
namespace pocket {
  /**
   * generated from pocket.click
   */
    struct ClickExtra {
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a pocket tile is clicked. Only happens on click. Not on middle-
     * click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<ClickExtra> click(57);

  /**
   * generated from pocket.enabled
   */
  /**
   * Whether Pocket is enabled on the newtab. AKA the "Recommended by Pocket"
     * section. Corresponds to the value of the `browser.newtabpage.activity-
     * stream.feeds.section.topstories` pref.
   */
  constexpr impl::BooleanMetric enabled(58);

  /**
   * generated from pocket.impression
   */
    struct ImpressionExtra {
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a pocket tile is visible to the user.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(59);

  /**
   * generated from pocket.is_signed_in
   */
  /**
   * Whether the Firefox user is signed in to Pocket. Does not correspond to a pref,
     * so its value is resampled at newtab's component init and whenever there is a
     * Discovery Stream user event.
   */
  constexpr impl::BooleanMetric is_signed_in(60);

  /**
   * generated from pocket.save
   */
    struct SaveExtra {
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user decides to save a pocket tile. Does not mean it ends up
     * successfully saved. Just that the user clicked on "Save to Pocket" in the
     * little pocket tile menu.
   */
  constexpr impl::EventMetric<SaveExtra> save(61);

  /**
   * generated from pocket.sponsored_stories_enabled
   */
  /**
   * Whether Pocket sponsored stories are enabled on the newtab. Corresponds to the
     * value of the `browser.newtabpage.activity-stream.showSponsored` pref. Can be
     * `true` even if pocket.enabled is `false`.
   */
  constexpr impl::BooleanMetric sponsored_stories_enabled(62);

  /**
   * generated from pocket.topic_click
   */
    struct TopicClickExtra {
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> topic;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (topic) {
          extraKeys.AppendElement()->AssignASCII("topic");
          extraValues.EmplaceBack(topic.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a pocket "Popular Topic" is clicked. Only happens on click. Not
     * on middle-click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<TopicClickExtra> topic_click(63);

}
namespace topsites {
  /**
   * generated from topsites.click
   */
    struct ClickExtra {
      mozilla::Maybe<nsCString> advertiserName;
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;
      mozilla::Maybe<nsCString> tileId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (advertiserName) {
          extraKeys.AppendElement()->AssignASCII("advertiser_name");
          extraValues.EmplaceBack(advertiserName.value());
        }
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        if (tileId) {
          extraKeys.AppendElement()->AssignASCII("tile_id");
          extraValues.EmplaceBack(tileId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a topsite tile is clicked. Only happens on click. Not on middle-
     * click. Not on "Open in new Tab"-like options in the context menu.
   */
  constexpr impl::EventMetric<ClickExtra> click(64);

  /**
   * generated from topsites.enabled
   */
  /**
   * Whether "topsites" is enabled on the newtab. AKA the "Shortcuts" section.
     * Corresponds to the value of the `browser.newtabpage.activity-
     * stream.feeds.topsites` pref.
   */
  constexpr impl::BooleanMetric enabled(65);

  /**
   * generated from topsites.impression
   */
    struct ImpressionExtra {
      mozilla::Maybe<nsCString> advertiserName;
      mozilla::Maybe<bool> isSponsored;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<uint32_t> position;
      mozilla::Maybe<nsCString> tileId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (advertiserName) {
          extraKeys.AppendElement()->AssignASCII("advertiser_name");
          extraValues.EmplaceBack(advertiserName.value());
        }
        if (isSponsored) {
          extraKeys.AppendElement()->AssignASCII("is_sponsored");
          extraValues.AppendElement()->AssignASCII(isSponsored.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (position) {
          extraKeys.AppendElement()->AssignASCII("position");
          extraValues.EmplaceBack(nsPrintfCString("%d", position.value()));
        }
        if (tileId) {
          extraKeys.AppendElement()->AssignASCII("tile_id");
          extraValues.EmplaceBack(tileId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when topsite tiles are loaded.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(66);

  /**
   * generated from topsites.rows
   */
  /**
   * The number of topsite tile rows configured to be shown on the newtab page.
     * Corresponds to the value of the `browser.newtabpage.activity-
     * stream.topSitesRows` pref. This is not the number of rows actually seen by the
     * user: if the browser window is partially off-screen, or isn't wide enough to
     * accommodate eight tiles per row, the actual number of rows may be different.
   */
  constexpr impl::QuantityMetric rows(67);

  /**
   * generated from topsites.sponsored_enabled
   */
  /**
   * Whether sponsored topsites are enabled on the newtab. AKA the "Sponsored
     * Shortcuts" section. Corresponds to the value of the
     * `browser.newtabpage.activity-stream.showSponsoredTopSites` pref. Can be `true`
     * even if topsites.enabled is `false`.
   */
  constexpr impl::BooleanMetric sponsored_enabled(68);

}
namespace newtab_search_ad {
  /**
   * generated from newtab.search.ad.click
   */
    struct ClickExtra {
      mozilla::Maybe<bool> isFollowOn;
      mozilla::Maybe<bool> isTagged;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> searchAccessPoint;
      mozilla::Maybe<nsCString> telemetryId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isFollowOn) {
          extraKeys.AppendElement()->AssignASCII("is_follow_on");
          extraValues.AppendElement()->AssignASCII(isFollowOn.value() ? "true" : "false");
        }
        if (isTagged) {
          extraKeys.AppendElement()->AssignASCII("is_tagged");
          extraValues.AppendElement()->AssignASCII(isTagged.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (searchAccessPoint) {
          extraKeys.AppendElement()->AssignASCII("search_access_point");
          extraValues.EmplaceBack(searchAccessPoint.value());
        }
        if (telemetryId) {
          extraKeys.AppendElement()->AssignASCII("telemetry_id");
          extraValues.EmplaceBack(telemetryId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when an ad link is clicked on a Search Engine Result Page (SERP) which
     * was loaded by a seach that began on a newtab page.
   */
  constexpr impl::EventMetric<ClickExtra> click(69);

  /**
   * generated from newtab.search.ad.impression
   */
    struct ImpressionExtra {
      mozilla::Maybe<bool> isFollowOn;
      mozilla::Maybe<bool> isTagged;
      mozilla::Maybe<nsCString> newtabVisitId;
      mozilla::Maybe<nsCString> searchAccessPoint;
      mozilla::Maybe<nsCString> telemetryId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (isFollowOn) {
          extraKeys.AppendElement()->AssignASCII("is_follow_on");
          extraValues.AppendElement()->AssignASCII(isFollowOn.value() ? "true" : "false");
        }
        if (isTagged) {
          extraKeys.AppendElement()->AssignASCII("is_tagged");
          extraValues.AppendElement()->AssignASCII(isTagged.value() ? "true" : "false");
        }
        if (newtabVisitId) {
          extraKeys.AppendElement()->AssignASCII("newtab_visit_id");
          extraValues.EmplaceBack(newtabVisitId.value());
        }
        if (searchAccessPoint) {
          extraKeys.AppendElement()->AssignASCII("search_access_point");
          extraValues.EmplaceBack(searchAccessPoint.value());
        }
        if (telemetryId) {
          extraKeys.AppendElement()->AssignASCII("telemetry_id");
          extraValues.EmplaceBack(telemetryId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a newtab visit resulted in a search that loaded a Search Engine
     * Result Page (SERP) that contains an ad link. And the SERP is visible.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(70);

}
namespace serp {
  /**
   * generated from serp.abandonment
   */
    struct AbandonmentExtra {
      mozilla::Maybe<nsCString> impressionId;
      mozilla::Maybe<nsCString> reason;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (impressionId) {
          extraKeys.AppendElement()->AssignASCII("impression_id");
          extraValues.EmplaceBack(impressionId.value());
        }
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when there is no engagement with the SERP before the tab is closed,
     * the window is closed, the app is closed, or the tab is navigated away from.
   */
  constexpr impl::EventMetric<AbandonmentExtra> abandonment(71);

  /**
   * generated from serp.ad_impression
   */
    struct AdImpressionExtra {
      mozilla::Maybe<uint32_t> adsHidden;
      mozilla::Maybe<uint32_t> adsLoaded;
      mozilla::Maybe<uint32_t> adsVisible;
      mozilla::Maybe<nsCString> component;
      mozilla::Maybe<nsCString> impressionId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (adsHidden) {
          extraKeys.AppendElement()->AssignASCII("ads_hidden");
          extraValues.EmplaceBack(nsPrintfCString("%d", adsHidden.value()));
        }
        if (adsLoaded) {
          extraKeys.AppendElement()->AssignASCII("ads_loaded");
          extraValues.EmplaceBack(nsPrintfCString("%d", adsLoaded.value()));
        }
        if (adsVisible) {
          extraKeys.AppendElement()->AssignASCII("ads_visible");
          extraValues.EmplaceBack(nsPrintfCString("%d", adsVisible.value()));
        }
        if (component) {
          extraKeys.AppendElement()->AssignASCII("component");
          extraValues.EmplaceBack(component.value());
        }
        if (impressionId) {
          extraKeys.AppendElement()->AssignASCII("impression_id");
          extraValues.EmplaceBack(impressionId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user loads a SERP and ads are detected.
   */
  constexpr impl::EventMetric<AdImpressionExtra> ad_impression(72);

  /**
   * generated from serp.categorization_duration
   */
  /**
   * The time it takes to categorize elements on a SERP.
   */
  constexpr impl::TimingDistributionMetric categorization_duration(73);

  /**
   * generated from serp.engagement
   */
    struct EngagementExtra {
      mozilla::Maybe<nsCString> action;
      mozilla::Maybe<nsCString> impressionId;
      mozilla::Maybe<nsCString> target;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (action) {
          extraKeys.AppendElement()->AssignASCII("action");
          extraValues.EmplaceBack(action.value());
        }
        if (impressionId) {
          extraKeys.AppendElement()->AssignASCII("impression_id");
          extraValues.EmplaceBack(impressionId.value());
        }
        if (target) {
          extraKeys.AppendElement()->AssignASCII("target");
          extraValues.EmplaceBack(target.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded user actions on a SERP.
   */
  constexpr impl::EventMetric<EngagementExtra> engagement(74);

  /**
   * generated from serp.impression
   */
    struct ImpressionExtra {
      mozilla::Maybe<nsCString> impressionId;
      mozilla::Maybe<bool> isShoppingPage;
      mozilla::Maybe<nsCString> partnerCode;
      mozilla::Maybe<nsCString> provider;
      mozilla::Maybe<bool> shoppingTabDisplayed;
      mozilla::Maybe<nsCString> source;
      mozilla::Maybe<bool> tagged;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (impressionId) {
          extraKeys.AppendElement()->AssignASCII("impression_id");
          extraValues.EmplaceBack(impressionId.value());
        }
        if (isShoppingPage) {
          extraKeys.AppendElement()->AssignASCII("is_shopping_page");
          extraValues.AppendElement()->AssignASCII(isShoppingPage.value() ? "true" : "false");
        }
        if (partnerCode) {
          extraKeys.AppendElement()->AssignASCII("partner_code");
          extraValues.EmplaceBack(partnerCode.value());
        }
        if (provider) {
          extraKeys.AppendElement()->AssignASCII("provider");
          extraValues.EmplaceBack(provider.value());
        }
        if (shoppingTabDisplayed) {
          extraKeys.AppendElement()->AssignASCII("shopping_tab_displayed");
          extraValues.AppendElement()->AssignASCII(shoppingTabDisplayed.value() ? "true" : "false");
        }
        if (source) {
          extraKeys.AppendElement()->AssignASCII("source");
          extraValues.EmplaceBack(source.value());
        }
        if (tagged) {
          extraKeys.AppendElement()->AssignASCII("tagged");
          extraValues.AppendElement()->AssignASCII(tagged.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a search engine results page (SERP) is shown to a user.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(75);

}
namespace translations_panel {
  /**
   * generated from translations.panel.open
   */
    struct OpenExtra {
      mozilla::Maybe<nsCString> openedFrom;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (openedFrom) {
          extraKeys.AppendElement()->AssignASCII("opened_from");
          extraValues.EmplaceBack(openedFrom.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Triggers when the translations panel is opened.
   */
  constexpr impl::EventMetric<OpenExtra> open(76);

}
namespace urlbar {
  /**
   * generated from urlbar.abandonment
   */
    struct AbandonmentExtra {
      mozilla::Maybe<nsCString> groups;
      mozilla::Maybe<nsCString> interaction;
      mozilla::Maybe<uint32_t> nChars;
      mozilla::Maybe<uint32_t> nResults;
      mozilla::Maybe<uint32_t> nWords;
      mozilla::Maybe<nsCString> results;
      mozilla::Maybe<nsCString> sap;
      mozilla::Maybe<nsCString> searchMode;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (groups) {
          extraKeys.AppendElement()->AssignASCII("groups");
          extraValues.EmplaceBack(groups.value());
        }
        if (interaction) {
          extraKeys.AppendElement()->AssignASCII("interaction");
          extraValues.EmplaceBack(interaction.value());
        }
        if (nChars) {
          extraKeys.AppendElement()->AssignASCII("n_chars");
          extraValues.EmplaceBack(nsPrintfCString("%d", nChars.value()));
        }
        if (nResults) {
          extraKeys.AppendElement()->AssignASCII("n_results");
          extraValues.EmplaceBack(nsPrintfCString("%d", nResults.value()));
        }
        if (nWords) {
          extraKeys.AppendElement()->AssignASCII("n_words");
          extraValues.EmplaceBack(nsPrintfCString("%d", nWords.value()));
        }
        if (results) {
          extraKeys.AppendElement()->AssignASCII("results");
          extraValues.EmplaceBack(results.value());
        }
        if (sap) {
          extraKeys.AppendElement()->AssignASCII("sap");
          extraValues.EmplaceBack(sap.value());
        }
        if (searchMode) {
          extraKeys.AppendElement()->AssignASCII("search_mode");
          extraValues.EmplaceBack(searchMode.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the user abandons a search (blurring the urlbar).
   */
  constexpr impl::EventMetric<AbandonmentExtra> abandonment(77);

  /**
   * generated from urlbar.engagement
   */
    struct EngagementExtra {
      mozilla::Maybe<nsCString> engagementType;
      mozilla::Maybe<nsCString> groups;
      mozilla::Maybe<nsCString> interaction;
      mozilla::Maybe<uint32_t> nChars;
      mozilla::Maybe<uint32_t> nResults;
      mozilla::Maybe<uint32_t> nWords;
      mozilla::Maybe<nsCString> provider;
      mozilla::Maybe<nsCString> results;
      mozilla::Maybe<nsCString> sap;
      mozilla::Maybe<nsCString> searchMode;
      mozilla::Maybe<nsCString> selectedResult;
      mozilla::Maybe<nsCString> selectedResultSubtype;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (engagementType) {
          extraKeys.AppendElement()->AssignASCII("engagement_type");
          extraValues.EmplaceBack(engagementType.value());
        }
        if (groups) {
          extraKeys.AppendElement()->AssignASCII("groups");
          extraValues.EmplaceBack(groups.value());
        }
        if (interaction) {
          extraKeys.AppendElement()->AssignASCII("interaction");
          extraValues.EmplaceBack(interaction.value());
        }
        if (nChars) {
          extraKeys.AppendElement()->AssignASCII("n_chars");
          extraValues.EmplaceBack(nsPrintfCString("%d", nChars.value()));
        }
        if (nResults) {
          extraKeys.AppendElement()->AssignASCII("n_results");
          extraValues.EmplaceBack(nsPrintfCString("%d", nResults.value()));
        }
        if (nWords) {
          extraKeys.AppendElement()->AssignASCII("n_words");
          extraValues.EmplaceBack(nsPrintfCString("%d", nWords.value()));
        }
        if (provider) {
          extraKeys.AppendElement()->AssignASCII("provider");
          extraValues.EmplaceBack(provider.value());
        }
        if (results) {
          extraKeys.AppendElement()->AssignASCII("results");
          extraValues.EmplaceBack(results.value());
        }
        if (sap) {
          extraKeys.AppendElement()->AssignASCII("sap");
          extraValues.EmplaceBack(sap.value());
        }
        if (searchMode) {
          extraKeys.AppendElement()->AssignASCII("search_mode");
          extraValues.EmplaceBack(searchMode.value());
        }
        if (selectedResult) {
          extraKeys.AppendElement()->AssignASCII("selected_result");
          extraValues.EmplaceBack(selectedResult.value());
        }
        if (selectedResultSubtype) {
          extraKeys.AppendElement()->AssignASCII("selected_result_subtype");
          extraValues.EmplaceBack(selectedResultSubtype.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the user executes an action on a result.
   */
  constexpr impl::EventMetric<EngagementExtra> engagement(78);

  /**
   * generated from urlbar.exposure
   */
    struct ExposureExtra {
      mozilla::Maybe<nsCString> results;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (results) {
          extraKeys.AppendElement()->AssignASCII("results");
          extraValues.EmplaceBack(results.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when client is exposed to urlbar experiment results.
   */
  constexpr impl::EventMetric<ExposureExtra> exposure(79);

  /**
   * generated from urlbar.impression
   */
    struct ImpressionExtra {
      mozilla::Maybe<nsCString> groups;
      mozilla::Maybe<nsCString> interaction;
      mozilla::Maybe<uint32_t> nChars;
      mozilla::Maybe<uint32_t> nResults;
      mozilla::Maybe<uint32_t> nWords;
      mozilla::Maybe<nsCString> reason;
      mozilla::Maybe<nsCString> results;
      mozilla::Maybe<nsCString> sap;
      mozilla::Maybe<nsCString> searchMode;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (groups) {
          extraKeys.AppendElement()->AssignASCII("groups");
          extraValues.EmplaceBack(groups.value());
        }
        if (interaction) {
          extraKeys.AppendElement()->AssignASCII("interaction");
          extraValues.EmplaceBack(interaction.value());
        }
        if (nChars) {
          extraKeys.AppendElement()->AssignASCII("n_chars");
          extraValues.EmplaceBack(nsPrintfCString("%d", nChars.value()));
        }
        if (nResults) {
          extraKeys.AppendElement()->AssignASCII("n_results");
          extraValues.EmplaceBack(nsPrintfCString("%d", nResults.value()));
        }
        if (nWords) {
          extraKeys.AppendElement()->AssignASCII("n_words");
          extraValues.EmplaceBack(nsPrintfCString("%d", nWords.value()));
        }
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        if (results) {
          extraKeys.AppendElement()->AssignASCII("results");
          extraValues.EmplaceBack(results.value());
        }
        if (sap) {
          extraKeys.AppendElement()->AssignASCII("sap");
          extraValues.EmplaceBack(sap.value());
        }
        if (searchMode) {
          extraKeys.AppendElement()->AssignASCII("search_mode");
          extraValues.EmplaceBack(searchMode.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when urlbar results are shown to the user.
   */
  constexpr impl::EventMetric<ImpressionExtra> impression(80);

  /**
   * generated from urlbar.pref_max_results
   */
  /**
   * Maximum results to show in the Address Bar. Corresponds to the value of the
     * `browser.urlbar.maxRichResults` pref.
   */
  constexpr impl::QuantityMetric pref_max_results(81);

  /**
   * generated from urlbar.pref_suggest_topsites
   */
  /**
   * Whether topsite results are enabled in the urlbar. Corresponds to the value of
     * the `browser.urlbar.suggest.topsites` pref.
   */
  constexpr impl::BooleanMetric pref_suggest_topsites(82);

}
namespace browser_engagement {
  /**
   * generated from browser.engagement.active_ticks
   */
  /**
   * The number of five-second intervals ('ticks') the user was considered
     * 'active'.
     * 
     * 'active' means keyboard or mouse interaction with the application.
     * It doesn't take into account whether or not the window has focus or is in
     * the foreground, only if it is receiving these interaction events.
     * 
     * Migrated from Telemetry's `browser.engagement.active_ticks`.
   */
  constexpr impl::CounterMetric active_ticks(83);

  /**
   * generated from browser.engagement.profile_count
   */
  /**
   * Windows only count of the browser profiles on the current system. This
     * counts profiles that have been used across all Windows user accounts on
     * machine since this probe was added. The value persists across installs.
     * A value of 0 is reported if there is an error determining the correct
     * count. Unset on other platforms.
   */
  constexpr impl::QuantityMetric profile_count(84);

  /**
   * generated from browser.engagement.uri_count
   */
  /**
   * The number of total non-unique http(s) URIs visited, including page
     * reloads, after the session has been restored. URIs on minimized or
     * background tabs may also be counted. Private browsing uris are included.
     * 
     * Migrated from Telemetry's
     * `browser.engagement.total_uri_count_normal_and_private_mode`.
   */
  constexpr impl::CounterMetric uri_count(85);

}
namespace ping_centre {
  /**
   * generated from ping.centre.send_failures
   */
  /**
   * The number of PingCentre send failures.
   */
  constexpr impl::CounterMetric send_failures(86);

  /**
   * generated from ping.centre.send_failures_by_namespace
   */
  enum class SendFailuresByNamespaceLabel: uint16_t {
      eActivityStream = 0,
      eMessagingSystem = 1,
      eContextualServices = 2,
      e__Other__,
    };
  /**
   * The number of PingCentre send failures,
     * broken down by structured ingestion namespace.
   */
  constexpr impl::Labeled<impl::CounterMetric, SendFailuresByNamespaceLabel> send_failures_by_namespace(87);

  /**
   * generated from ping.centre.send_successes_by_namespace
   */
  enum class SendSuccessesByNamespaceLabel: uint16_t {
      eActivityStream = 0,
      eMessagingSystem = 1,
      eContextualServices = 2,
      e__Other__,
    };
  /**
   * The number of PingCentre send successes,
     * broken down by structured ingestion namespace.
   */
  constexpr impl::Labeled<impl::CounterMetric, SendSuccessesByNamespaceLabel> send_successes_by_namespace(88);

}
namespace gmp {
  /**
   * generated from gmp.update_xml_fetch_result
   */
  enum class UpdateXmlFetchResultLabel: uint16_t {
      eCertPinSuccess = 0,
      eCertPinNetRequestError = 1,
      eCertPinNetTimeout = 2,
      eCertPinAbort = 3,
      eCertPinMissingData = 4,
      eCertPinFailed = 5,
      eCertPinInvalid = 6,
      eCertPinXmlParseError = 7,
      eCertPinUnknownError = 8,
      eContentSigSuccess = 9,
      eContentSigNetRequestError = 10,
      eContentSigNetTimeout = 11,
      eContentSigAbort = 12,
      eContentSigMissingData = 13,
      eContentSigFailed = 14,
      eContentSigInvalid = 15,
      eContentSigXmlParseError = 16,
      eContentSigUnknownError = 17,
      e__Other__,
    };
  /**
   * The result of Gecko fetching an update.xml from Balrog. This captures 3
     * different data points: success or failure of the request, if cert pinning or
     * content signatures were used to verify the result, and the reason for failure,
     * if the request failed.
   */
  constexpr impl::Labeled<impl::CounterMetric, UpdateXmlFetchResultLabel> update_xml_fetch_result(89);

}
namespace rtcrtpsender {
  /**
   * generated from rtcrtpsender.count
   */
  /**
   * The number of RTCRtpSenders created.
   */
  constexpr impl::DenominatorMetric count(90);

  /**
   * generated from rtcrtpsender.count_setparameters_compat
   */
  /**
   * The number of RTCRtpSenders created that use the compatibility mode for
     * setParameters.
   */
  constexpr impl::DenominatorMetric count_setparameters_compat(91);

  /**
   * generated from rtcrtpsender.used_sendencodings
   */
  /**
   * The proportion of RTCRtpSenders that were created by an addTransceivers call
     * that was passed a sendEncodings.
   */
  constexpr impl::NumeratorMetric used_sendencodings(92);

}
namespace rtcrtpsender_setparameters {
  /**
   * generated from rtcrtpsender.setparameters.blame_length_changed
   */
  /**
   * The number of RTCRtpSenders that have warned at least once about a
     * `setParameters` call that attempted to change the number of encodings, broken
     * down by the eTLD+1 of the site. Collected only on EARLY_BETA_OR_EARLIER.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> blame_length_changed(93);

  /**
   * generated from rtcrtpsender.setparameters.blame_no_getparameters
   */
  /**
   * The number of RTCRtpSenders that have warned at least once about a
     * `setParameters` call because `[[LastReturnedParameters]]` was not set, broken
     * down by the eTLD+1 of the site. (ie; there was not a recent enough call to
     * `getParameters`) Collected only on EARLY_BETA_OR_EARLIER.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> blame_no_getparameters(94);

  /**
   * generated from rtcrtpsender.setparameters.blame_no_transactionid
   */
  /**
   * The number of RTCRtpSenders that have warned at least once about a
     * `setParameters` call that did not set the transactionId field, broken down by
     * the eTLD+1 of the site. Collected only on EARLY_BETA_OR_EARLIER.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> blame_no_transactionid(95);

  /**
   * generated from rtcrtpsender.setparameters.blame_stale_transactionid
   */
  /**
   * The number of RTCRtpSenders that have warned at least once about a
     * `setParameters` call that used a stale transaction id, broken down by the
     * eTLD+1 of the site. Collected only on EARLY_BETA_OR_EARLIER.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> blame_stale_transactionid(96);

  /**
   * generated from rtcrtpsender.setparameters.fail_length_changed
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that attempted to change the number of encodings.
   */
  constexpr impl::NumeratorMetric fail_length_changed(97);

  /**
   * generated from rtcrtpsender.setparameters.fail_no_encodings
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have thrown an error at least once about a setParameters call that had no
     * encodings (we do not measure this against the general population of
     * RTCRtpSenders, since without the compat mode this failure is never observed,
     * because it fails the length change check).
   */
  constexpr impl::NumeratorMetric fail_no_encodings(98);

  /**
   * generated from rtcrtpsender.setparameters.fail_no_getparameters
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call because [[LastReturnedParameters]] was not set. (ie; there
     * was not a recent enough call to getParameters)
   */
  constexpr impl::NumeratorMetric fail_no_getparameters(99);

  /**
   * generated from rtcrtpsender.setparameters.fail_no_transactionid
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that did not set the transactionId field.
   */
  constexpr impl::NumeratorMetric fail_no_transactionid(100);

  /**
   * generated from rtcrtpsender.setparameters.fail_other
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that had no encodings.
   */
  constexpr impl::NumeratorMetric fail_other(101);

  /**
   * generated from rtcrtpsender.setparameters.fail_rid_changed
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that attempted to change the rid on an encoding (note that
     * we only check this if the encoding count did not change, see
     * fail_length_changed).
   */
  constexpr impl::NumeratorMetric fail_rid_changed(102);

  /**
   * generated from rtcrtpsender.setparameters.fail_stale_transactionid
   */
  /**
   * The proportion of RTCRtpSenders that have thrown an error at least once about a
     * setParameters call that used a stale transaction id.
   */
  constexpr impl::NumeratorMetric fail_stale_transactionid(103);

  /**
   * generated from rtcrtpsender.setparameters.warn_length_changed
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have warned at least once about a setParameters call that attempted to
     * change the number of encodings.
   */
  constexpr impl::NumeratorMetric warn_length_changed(104);

  /**
   * generated from rtcrtpsender.setparameters.warn_no_getparameters
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have warned at least once about a setParameters call because
     * [[LastReturnedParameters]] was not set.  (ie; there was not a recent enough
     * call to getParameters)
   */
  constexpr impl::NumeratorMetric warn_no_getparameters(105);

  /**
   * generated from rtcrtpsender.setparameters.warn_no_transactionid
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have warned at least once about a setParameters call that did not set the
     * transactionId field.
   */
  constexpr impl::NumeratorMetric warn_no_transactionid(106);

  /**
   * generated from rtcrtpsender.setparameters.warn_rid_changed
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have warned at least once about a setParameters call that attempted to
     * change the rid on an encoding (note that we only check this if the encoding
     * count did not change, see warn_length_changed).
   */
  constexpr impl::NumeratorMetric warn_rid_changed(107);

  /**
   * generated from rtcrtpsender.setparameters.warn_stale_transactionid
   */
  /**
   * The proportion of RTCRtpSenders configured with the setParameters compat mode
     * that have warned at least once about a setParameters call that used a stale
     * transaction id.
   */
  constexpr impl::NumeratorMetric warn_stale_transactionid(108);

}
namespace perf {
  /**
   * generated from perf.page_load
   */
    struct PageLoadExtra {
      mozilla::Maybe<uint32_t> dnsLookupTime;
      mozilla::Maybe<uint32_t> fcpTime;
      mozilla::Maybe<uint32_t> httpVer;
      mozilla::Maybe<uint32_t> jsExecTime;
      mozilla::Maybe<uint32_t> loadTime;
      mozilla::Maybe<nsCString> loadType;
      mozilla::Maybe<uint32_t> redirectCount;
      mozilla::Maybe<uint32_t> redirectTime;
      mozilla::Maybe<uint32_t> responseTime;
      mozilla::Maybe<bool> sameOriginNav;
      mozilla::Maybe<nsCString> trrDomain;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (dnsLookupTime) {
          extraKeys.AppendElement()->AssignASCII("dns_lookup_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", dnsLookupTime.value()));
        }
        if (fcpTime) {
          extraKeys.AppendElement()->AssignASCII("fcp_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", fcpTime.value()));
        }
        if (httpVer) {
          extraKeys.AppendElement()->AssignASCII("http_ver");
          extraValues.EmplaceBack(nsPrintfCString("%d", httpVer.value()));
        }
        if (jsExecTime) {
          extraKeys.AppendElement()->AssignASCII("js_exec_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", jsExecTime.value()));
        }
        if (loadTime) {
          extraKeys.AppendElement()->AssignASCII("load_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", loadTime.value()));
        }
        if (loadType) {
          extraKeys.AppendElement()->AssignASCII("load_type");
          extraValues.EmplaceBack(loadType.value());
        }
        if (redirectCount) {
          extraKeys.AppendElement()->AssignASCII("redirect_count");
          extraValues.EmplaceBack(nsPrintfCString("%d", redirectCount.value()));
        }
        if (redirectTime) {
          extraKeys.AppendElement()->AssignASCII("redirect_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", redirectTime.value()));
        }
        if (responseTime) {
          extraKeys.AppendElement()->AssignASCII("response_time");
          extraValues.EmplaceBack(nsPrintfCString("%d", responseTime.value()));
        }
        if (sameOriginNav) {
          extraKeys.AppendElement()->AssignASCII("same_origin_nav");
          extraValues.AppendElement()->AssignASCII(sameOriginNav.value() ? "true" : "false");
        }
        if (trrDomain) {
          extraKeys.AppendElement()->AssignASCII("trr_domain");
          extraValues.EmplaceBack(trrDomain.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a top level content document has been loaded.
   */
  constexpr impl::EventMetric<PageLoadExtra> page_load(109);

}
namespace paint {
  /**
   * generated from paint.build_displaylist_time
   */
  /**
   * The time to build a Gecko display list.
   */
  constexpr impl::TimingDistributionMetric build_displaylist_time(110);

}
namespace wr {
  /**
   * generated from wr.framebuild_time
   */
  /**
   * The time to rasterize glyphs for consumption by WebRender.
   */
  constexpr impl::TimingDistributionMetric framebuild_time(111);

  /**
   * generated from wr.gpu_wait_time
   */
  /**
   * The time spent waiting for the GPU to complete previously issued drawing
     * commands.
   */
  constexpr impl::TimingDistributionMetric gpu_wait_time(112);

  /**
   * generated from wr.rasterize_blobs_time
   */
  /**
   * The time to rasterize blobs for consumption by WebRender.
   */
  constexpr impl::TimingDistributionMetric rasterize_blobs_time(113);

  /**
   * generated from wr.rasterize_glyphs_time
   */
  /**
   * The time to rasterize glyphs for consumption by WebRender.
   */
  constexpr impl::TimingDistributionMetric rasterize_glyphs_time(114);

  /**
   * generated from wr.renderer_time
   */
  /**
   * WebRender renderer time.
   */
  constexpr impl::TimingDistributionMetric renderer_time(115);

  /**
   * generated from wr.renderer_time_no_sc
   */
  /**
   * WebRender renderer time excluding frames in which shader compilation took
     * place.
   */
  constexpr impl::TimingDistributionMetric renderer_time_no_sc(116);

  /**
   * generated from wr.scenebuild_time
   */
  /**
   * WebRender scene build time.
   */
  constexpr impl::TimingDistributionMetric scenebuild_time(117);

  /**
   * generated from wr.sceneswap_time
   */
  /**
   * WebRender scene swap time.
   */
  constexpr impl::TimingDistributionMetric sceneswap_time(118);

  /**
   * generated from wr.texture_cache_update_time
   */
  /**
   * Time taken by WebRender to update the texture cache.
   */
  constexpr impl::TimingDistributionMetric texture_cache_update_time(119);

  /**
   * generated from wr.time_to_frame_build
   */
  /**
   * Time elapsed between the construction of a transaction and the associated frame
     * build beginning.
   */
  constexpr impl::TimingDistributionMetric time_to_frame_build(120);

  /**
   * generated from wr.time_to_render_start
   */
  /**
   * Time elapsed between the construction of a frame and the start of rendering.
   */
  constexpr impl::TimingDistributionMetric time_to_render_start(121);

}
namespace dotprint {
  /**
   * generated from dotprint.android_dialog_requested
   */
  /**
   * Opening the Android print dialog was requested via window.print.
   */
  constexpr impl::CounterMetric android_dialog_requested(122);

  /**
   * generated from dotprint.failure
   */
  enum class FailureLabel: uint16_t {
      eNoSettingsService = 0,
      eNoSettings = 1,
      eNoCanonicalContext = 2,
      eNoActivityContextDelegate = 3,
      eNoActivityContext = 4,
      eIoError = 5,
      eUnknown = 6,
      e__Other__,
    };
  /**
   * An error occured while setting up for printing. Default label is 'unknown'.
   */
  constexpr impl::Labeled<impl::CounterMetric, FailureLabel> failure(123);

  /**
   * generated from dotprint.requested
   */
  /**
   * How many times window.print was requested.
   */
  constexpr impl::CounterMetric requested(124);

}
namespace networking {
  /**
   * generated from networking.cookie_access_fixup_diff
   */
  /**
   * If we fix up a cookie lastAccessed timestamp that is in the future this metric
     * records the number of seconds that timestamp was off from NOW.
   */
  constexpr impl::CustomDistributionMetric cookie_access_fixup_diff(125);

  /**
   * generated from networking.cookie_creation_fixup_diff
   */
  /**
   * If we fix up a cookie creation timestamp that is in the future this metric
     * records the number of seconds that timestamp was off from NOW.
   */
  constexpr impl::CustomDistributionMetric cookie_creation_fixup_diff(126);

  /**
   * generated from networking.cookie_timestamp_fixed_count
   */
  enum class CookieTimestampFixedCountLabel: uint16_t {
      eCreationtime = 0,
      eLastaccessed = 1,
      e__Other__,
    };
  /**
   * Counts the number of times a cookie's invalid timestamp was fixed when reading
     * it from the DB.
   */
  constexpr impl::Labeled<impl::CounterMetric, CookieTimestampFixedCountLabel> cookie_timestamp_fixed_count(127);

  /**
   * generated from networking.speculative_connect_outcome
   */
  enum class SpeculativeConnectOutcomeLabel: uint16_t {
      eSuccessful = 0,
      eAbortedSocketLimit = 1,
      eAbortedSocketFail = 2,
      eAbortedHttpsNotEnabled = 3,
      e__Other__,
    };
  /**
   * Counts the occurrence of each outcome of a speculative connection
   */
  constexpr impl::Labeled<impl::CounterMetric, SpeculativeConnectOutcomeLabel> speculative_connect_outcome(128);

}
namespace netwerk {
  /**
   * generated from netwerk.early_hints
   */
  enum class EarlyHintsLabel: uint16_t {
      eStylesheet = 0,
      eFonts = 1,
      eScripts = 2,
      eFetch = 3,
      eImage = 4,
      eOther = 5,
      e__Other__,
    };
  /**
   * Counts the different type of resources that are sent for early hints.
   */
  constexpr impl::Labeled<impl::CounterMetric, EarlyHintsLabel> early_hints(129);

  /**
   * generated from netwerk.eh_link_type
   */
  enum class EhLinkTypeLabel: uint16_t {
      eDnsPrefetch = 0,
      eIcon = 1,
      eModulepreload = 2,
      ePreconnect = 3,
      ePrefetch = 4,
      ePreload = 5,
      ePrerender = 6,
      eStylesheet = 7,
      eOther = 8,
      e__Other__,
    };
  /**
   * Counts different type of link headers that are sent in early hint
   */
  constexpr impl::Labeled<impl::CounterMetric, EhLinkTypeLabel> eh_link_type(130);

}
namespace network {
  /**
   * generated from network.cors_authorization_header
   */
  enum class CorsAuthorizationHeaderLabel: uint16_t {
      eAllowed = 0,
      eDisallowed = 1,
      eCoveredByWildcard = 2,
      e__Other__,
    };
  /**
   * Count how many times we see `Authorization` header in `Access-Control-Request-
     * Headers` header and the possible outcomes.
   */
  constexpr impl::Labeled<impl::CounterMetric, CorsAuthorizationHeaderLabel> cors_authorization_header(131);

  /**
   * generated from network.data_size_pb_per_type
   */
  enum class DataSizePbPerTypeLabel: uint16_t {
      eTextHtml = 0,
      eTextCss = 1,
      eTextJson = 2,
      eTextPlain = 3,
      eTextJavascript = 4,
      eTextOther = 5,
      eAudio = 6,
      eVideo = 7,
      eMultipart = 8,
      eIcon = 9,
      eImage = 10,
      eOcsp = 11,
      eXpinstall = 12,
      eWasm = 13,
      ePdf = 14,
      eOctetStream = 15,
      eProxy = 16,
      eCompressed = 17,
      eX509 = 18,
      eApplicationOther = 19,
      e__Other__,
    };
  /**
   * Number of KB we transferred keyed by "contentType"
   */
  constexpr impl::Labeled<impl::CounterMetric, DataSizePbPerTypeLabel> data_size_pb_per_type(132);

  /**
   * generated from network.data_size_per_type
   */
  enum class DataSizePerTypeLabel: uint16_t {
      eTextHtml = 0,
      eTextCss = 1,
      eTextJson = 2,
      eTextPlain = 3,
      eTextJavascript = 4,
      eTextOther = 5,
      eAudio = 6,
      eVideo = 7,
      eMultipart = 8,
      eIcon = 9,
      eImage = 10,
      eOcsp = 11,
      eXpinstall = 12,
      eWasm = 13,
      ePdf = 14,
      eOctetStream = 15,
      eProxy = 16,
      eCompressed = 17,
      eX509 = 18,
      eApplicationOther = 19,
      e__Other__,
    };
  /**
   * Number of KB we transferred keyed by "contentType"
   */
  constexpr impl::Labeled<impl::CounterMetric, DataSizePerTypeLabel> data_size_per_type(133);

}
namespace background_tasks_rmdir_base {
  /**
   * generated from background_tasks.rmdir.base.elapsed_ms
   */
  /**
   * The amount of time the task took for removing the directories.
   */
  constexpr impl::QuantityMetric elapsed_ms(134);

  /**
   * generated from background_tasks.rmdir.base.metric_base
   */
  /**
   * The base metric template for removeDirectory.
   */
  constexpr impl::EventMetric<NoExtraKeys> metric_base(135);

  /**
   * generated from background_tasks.rmdir.base.removal_count
   */
  /**
   * The number of the removed entries at each call, even if the target directory
     * itself couldn't be removed.
   */
  constexpr impl::QuantityMetric removal_count(136);

  /**
   * generated from background_tasks.rmdir.base.retry_count
   */
  /**
   * The number of retries before the task started removing the child directory.
     * This can happen when the target directory doesn't exist.
   */
  constexpr impl::QuantityMetric retry_count(137);

  /**
   * generated from background_tasks.rmdir.base.succeeded
   */
  /**
   * Whether the target directory removal succeeded.
   */
  constexpr impl::BooleanMetric succeeded(138);

  /**
   * generated from background_tasks.rmdir.base.suffix_ever_failed
   */
  /**
   * Whether removing the suffixed directories ever failed.
   */
  constexpr impl::BooleanMetric suffix_ever_failed(139);

  /**
   * generated from background_tasks.rmdir.base.suffix_removal_count
   */
  /**
   * The number of the removed entries of the suffixed directories.
   */
  constexpr impl::QuantityMetric suffix_removal_count(140);

  /**
   * generated from background_tasks.rmdir.base.was_first
   */
  /**
   * Whether this task is the first one removing the directory.
   */
  constexpr impl::BooleanMetric was_first(141);

}
namespace background_tasks_rmdir_http_cache {
  /**
   * generated from background_tasks.rmdir.http_cache.elapsed_ms
   */
  /**
   * The amount of time the task took for removing the directories.
   */
  constexpr impl::QuantityMetric elapsed_ms(142);

  /**
   * generated from background_tasks.rmdir.http_cache.metric_base
   */
  /**
   * The base metric template for removeDirectory.
   */
  constexpr impl::EventMetric<NoExtraKeys> metric_base(143);

  /**
   * generated from background_tasks.rmdir.http_cache.removal_count
   */
  /**
   * The number of the removed entries at each call, even if the target directory
     * itself couldn't be removed.
   */
  constexpr impl::QuantityMetric removal_count(144);

  /**
   * generated from background_tasks.rmdir.http_cache.retry_count
   */
  /**
   * The number of retries before the task started removing the child directory.
     * This can happen when the target directory doesn't exist.
   */
  constexpr impl::QuantityMetric retry_count(145);

  /**
   * generated from background_tasks.rmdir.http_cache.succeeded
   */
  /**
   * Whether the target directory removal succeeded.
   */
  constexpr impl::BooleanMetric succeeded(146);

  /**
   * generated from background_tasks.rmdir.http_cache.suffix_ever_failed
   */
  /**
   * Whether removing the suffixed directories ever failed.
   */
  constexpr impl::BooleanMetric suffix_ever_failed(147);

  /**
   * generated from background_tasks.rmdir.http_cache.suffix_removal_count
   */
  /**
   * The number of the removed entries of the suffixed directories.
   */
  constexpr impl::QuantityMetric suffix_removal_count(148);

  /**
   * generated from background_tasks.rmdir.http_cache.was_first
   */
  /**
   * Whether this task is the first one removing the directory.
   */
  constexpr impl::BooleanMetric was_first(149);

}
namespace background_tasks_rmdir_quota {
  /**
   * generated from background_tasks.rmdir.quota.elapsed_ms
   */
  /**
   * The amount of time the task took for removing the directories.
   */
  constexpr impl::QuantityMetric elapsed_ms(150);

  /**
   * generated from background_tasks.rmdir.quota.metric_base
   */
  /**
   * The base metric template for removeDirectory.
   */
  constexpr impl::EventMetric<NoExtraKeys> metric_base(151);

  /**
   * generated from background_tasks.rmdir.quota.removal_count
   */
  /**
   * The number of the removed entries at each call, even if the target directory
     * itself couldn't be removed.
   */
  constexpr impl::QuantityMetric removal_count(152);

  /**
   * generated from background_tasks.rmdir.quota.retry_count
   */
  /**
   * The number of retries before the task started removing the child directory.
     * This can happen when the target directory doesn't exist.
   */
  constexpr impl::QuantityMetric retry_count(153);

  /**
   * generated from background_tasks.rmdir.quota.succeeded
   */
  /**
   * Whether the target directory removal succeeded.
   */
  constexpr impl::BooleanMetric succeeded(154);

  /**
   * generated from background_tasks.rmdir.quota.suffix_ever_failed
   */
  /**
   * Whether removing the suffixed directories ever failed.
   */
  constexpr impl::BooleanMetric suffix_ever_failed(155);

  /**
   * generated from background_tasks.rmdir.quota.suffix_removal_count
   */
  /**
   * The number of the removed entries of the suffixed directories.
   */
  constexpr impl::QuantityMetric suffix_removal_count(156);

  /**
   * generated from background_tasks.rmdir.quota.was_first
   */
  /**
   * Whether this task is the first one removing the directory.
   */
  constexpr impl::BooleanMetric was_first(157);

}
namespace cookie_banners {
  /**
   * generated from cookie.banners.normal_window_service_mode
   */
  enum class NormalWindowServiceModeLabel: uint16_t {
      eDisabled = 0,
      eReject = 1,
      eRejectOrAccept = 2,
      eInvalid = 3,
      e__Other__,
    };
  /**
   * The pref value of the cookie banner service mode for normal windows.
   */
  constexpr impl::Labeled<impl::BooleanMetric, NormalWindowServiceModeLabel> normal_window_service_mode(158);

  /**
   * generated from cookie.banners.private_window_service_mode
   */
  enum class PrivateWindowServiceModeLabel: uint16_t {
      eDisabled = 0,
      eReject = 1,
      eRejectOrAccept = 2,
      eInvalid = 3,
      e__Other__,
    };
  /**
   * The pref value of the cookie banner service mode for private windows.
   */
  constexpr impl::Labeled<impl::BooleanMetric, PrivateWindowServiceModeLabel> private_window_service_mode(159);

  /**
   * generated from cookie.banners.reload
   */
    struct ReloadExtra {
      mozilla::Maybe<bool> hasClickRule;
      mozilla::Maybe<bool> hasCookieRule;
      mozilla::Maybe<bool> noRule;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (hasClickRule) {
          extraKeys.AppendElement()->AssignASCII("has_click_rule");
          extraValues.AppendElement()->AssignASCII(hasClickRule.value() ? "true" : "false");
        }
        if (hasCookieRule) {
          extraKeys.AppendElement()->AssignASCII("has_cookie_rule");
          extraValues.AppendElement()->AssignASCII(hasCookieRule.value() ? "true" : "false");
        }
        if (noRule) {
          extraKeys.AppendElement()->AssignASCII("no_rule");
          extraValues.AppendElement()->AssignASCII(noRule.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the top-level page is reloaded. We use this event metric to know
     * whether or not the reloading domain has cookie banner rule.
   */
  constexpr impl::EventMetric<ReloadExtra> reload(160);

  /**
   * generated from cookie.banners.rule_lookup_by_domain
   */
  enum class RuleLookupByDomainLabel: uint16_t {
      eTopHit = 0,
      eTopHitOptIn = 1,
      eTopHitOptOut = 2,
      eTopMiss = 3,
      eIframeHit = 4,
      eIframeHitOptIn = 5,
      eIframeHitOptOut = 6,
      eIframeMiss = 7,
      eTopCookieHit = 8,
      eTopCookieHitOptIn = 9,
      eTopCookieHitOptOut = 10,
      eTopCookieMiss = 11,
      eIframeCookieHit = 12,
      eIframeCookieHitOptIn = 13,
      eIframeCookieHitOptOut = 14,
      eIframeCookieMiss = 15,
      eTopClickHit = 16,
      eTopClickHitOptIn = 17,
      eTopClickHitOptOut = 18,
      eTopClickMiss = 19,
      eIframeClickHit = 20,
      eIframeClickHitOptIn = 21,
      eIframeClickHitOptOut = 22,
      eIframeClickMiss = 23,
      e__Other__,
    };
  /**
   * Counts the number of hit/miss of cookie banner rule lookups for domain. We
     * collect three types of counters, including counters for overall rule lookup,
     * counters for cookie rule lookup and counters for click rule lookup. We also
     * divide the counter by top-level loads and iframe loads. For each domain, we
     * will only collect once.
   */
  constexpr impl::Labeled<impl::CounterMetric, RuleLookupByDomainLabel> rule_lookup_by_domain(161);

  /**
   * generated from cookie.banners.rule_lookup_by_load
   */
  enum class RuleLookupByLoadLabel: uint16_t {
      eTopHit = 0,
      eTopHitOptIn = 1,
      eTopHitOptOut = 2,
      eTopMiss = 3,
      eIframeHit = 4,
      eIframeHitOptIn = 5,
      eIframeHitOptOut = 6,
      eIframeMiss = 7,
      eTopCookieHit = 8,
      eTopCookieHitOptIn = 9,
      eTopCookieHitOptOut = 10,
      eTopCookieMiss = 11,
      eIframeCookieHit = 12,
      eIframeCookieHitOptIn = 13,
      eIframeCookieHitOptOut = 14,
      eIframeCookieMiss = 15,
      eTopClickHit = 16,
      eTopClickHitOptIn = 17,
      eTopClickHitOptOut = 18,
      eTopClickMiss = 19,
      eIframeClickHit = 20,
      eIframeClickHitOptIn = 21,
      eIframeClickHitOptOut = 22,
      eIframeClickMiss = 23,
      e__Other__,
    };
  /**
   * Counts the number of hit/miss of cookie banner rule lookups for every load. We
     * collect three types of counters, including counters for overall rule lookup,
     * counters for cookie rule lookup and counters for click rule lookup. We also
     * divide the counter by top-level loads and iframe loads.
   */
  constexpr impl::Labeled<impl::CounterMetric, RuleLookupByLoadLabel> rule_lookup_by_load(162);

  /**
   * generated from cookie.banners.service_detect_only
   */
  /**
   * Tracks the value of the cookiebanners.service.detectOnly pref.
   */
  constexpr impl::BooleanMetric service_detect_only(163);

}
namespace cookie_banners_click {
  /**
   * generated from cookie.banners.click.handle_duration
   */
  /**
   * Counts how long it takes to handle cookie banners successfully from
     * DOMContentLoaded until click.
   */
  constexpr impl::TimingDistributionMetric handle_duration(164);

  /**
   * generated from cookie.banners.click.result
   */
  enum class ResultLabel: uint16_t {
      eSuccess = 0,
      eSuccessCookieInjected = 1,
      eSuccessDomContentLoaded = 2,
      eSuccessMutationPreLoad = 3,
      eSuccessMutationPostLoad = 4,
      eFail = 5,
      eFailBannerNotFound = 6,
      eFailBannerNotVisible = 7,
      eFailButtonNotFound = 8,
      eFailNoRuleForMode = 9,
      eFailActorDestroyed = 10,
      e__Other__,
    };
  /**
   * Given a matching cookie banner rule, how often do we handle or fail to handle
     * cookie banners, labelled by reason. The 'success' and 'fail' counters count the
     * total numbers independently of the reason counters. Counters are incremented
     * after the content window has been destroyed. This metric additionally reports
     * cookie injections after which we didn't see a banner as
     * "success_cookie_injected".
   */
  constexpr impl::Labeled<impl::CounterMetric, ResultLabel> result(165);

}
namespace crash {
  /**
   * generated from crash.process_type
   */
  /**
   * The type of process that experienced a crash. See the full list of options
     * [here](https://firefox-source-
     * docs.mozilla.org/toolkit/components/telemetry/data/crash-ping.html#process-
     * types).
   */
  constexpr impl::StringMetric process_type(166);

  /**
   * generated from crash.startup
   */
  /**
   * If true, the crash occurred during process startup.
   */
  constexpr impl::BooleanMetric startup(167);

  /**
   * generated from crash.time
   */
  /**
   * The time at which the crash occurred.
   */
  constexpr impl::DatetimeMetric time(168);

  /**
   * generated from crash.uptime
   */
  /**
   * The application uptime. This is equivalent to the legacy crash ping's
     * `UptimeTS` field.
   */
  constexpr impl::TimespanMetric uptime(169);

}
namespace extensions {
  /**
   * generated from extensions.startup_cache_load_time
   */
  /**
   * Time to load and deserialize the extensions startupCache data.
   */
  constexpr impl::TimespanMetric startup_cache_load_time(170);

}
namespace extensions_apis_dnr {
  /**
   * generated from extensions.apis.dnr.evaluate_rules_count_max
   */
  /**
   * Max amount of DNR rules being evaluated.
   */
  constexpr impl::QuantityMetric evaluate_rules_count_max(171);

  /**
   * generated from extensions.apis.dnr.evaluate_rules_time
   */
  /**
   * Amount of time it takes to evaluate DNR rules for one network request.
   */
  constexpr impl::TimingDistributionMetric evaluate_rules_time(172);

  /**
   * generated from extensions.apis.dnr.startup_cache_entries
   */
  enum class StartupCacheEntriesLabel: uint16_t {
      eHit = 0,
      eMiss = 1,
      e__Other__,
    };
  /**
   * Counters for startup cache data hits or misses on initializating
     * DNR rules for extensions loaded on application startup.
   */
  constexpr impl::Labeled<impl::CounterMetric, StartupCacheEntriesLabel> startup_cache_entries(173);

  /**
   * generated from extensions.apis.dnr.startup_cache_read_size
   */
  /**
   * Amount of data read from the DNR startup cache file.
   */
  constexpr impl::MemoryDistributionMetric startup_cache_read_size(174);

  /**
   * generated from extensions.apis.dnr.startup_cache_read_time
   */
  /**
   * Amount of time it takes to read data into the DNR startup cache file.
   */
  constexpr impl::TimingDistributionMetric startup_cache_read_time(175);

  /**
   * generated from extensions.apis.dnr.startup_cache_write_size
   */
  /**
   * Amount of data written to the DNR startup cache file.
   */
  constexpr impl::MemoryDistributionMetric startup_cache_write_size(176);

  /**
   * generated from extensions.apis.dnr.startup_cache_write_time
   */
  /**
   * Amount of time it takes to write data into the DNR startup cache file.
   */
  constexpr impl::TimingDistributionMetric startup_cache_write_time(177);

  /**
   * generated from extensions.apis.dnr.validate_rules_time
   */
  /**
   * Amount of time it takes to validate DNR rules of individual ruleset
     * when dynamic or static rulesets have been loaded from disk.
   */
  constexpr impl::TimingDistributionMetric validate_rules_time(178);

}
namespace fog {
  /**
   * generated from fog.failed_idle_registration
   */
  /**
   * True if we failed to register with the idle service. Absent otherwise.
     * Means IPC probably isn't working well.
     * Child-process data will likely be absent, or incomplete.
   */
  constexpr impl::BooleanMetric failed_idle_registration(179);

  /**
   * generated from fog.initialization
   */
  /**
   * Time the FOG initialization takes.
   */
  constexpr impl::TimespanMetric initialization(180);

}
namespace fog_ipc {
  /**
   * generated from fog.ipc.buffer_sizes
   */
  /**
   * The number and size of the IPC buffers being received over FOG IPC.
   */
  constexpr impl::MemoryDistributionMetric buffer_sizes(181);

  /**
   * generated from fog.ipc.flush_durations
   */
  /**
   * The length of time between asking the child processes for their
     * IPC buffers and all of them being received by the parent.
   */
  constexpr impl::TimingDistributionMetric flush_durations(182);

  /**
   * generated from fog.ipc.flush_failures
   */
  /**
   * The number of times we failed to flush all non-parent-process data,
     * throwing even partial results into the trash.
     * If this number is high, we might consider writing custom `MozPromise`-
     * handling code instead of using `MozPromise::All`.
   */
  constexpr impl::CounterMetric flush_failures(183);

  /**
   * generated from fog.ipc.replay_failures
   */
  /**
   * The number of times the ipc buffer failed to be replayed in the
     * parent process.
   */
  constexpr impl::CounterMetric replay_failures(184);

  /**
   * generated from fog.ipc.shutdown_registration_failures
   */
  /**
   * The number of times we tried to register shutdown flush routines for
     * content child processes, and failed (probably because there was no main
     * thread).
     * As a result there may be data loss from content child processes.
     * Large or rising number of clients experiencing this indicates we should
     * perhaps refactor content child shutdown in FOG to try harder to register
     * flush operations.
     * Will likely be obsoleted by bug 1641989.
   */
  constexpr impl::CounterMetric shutdown_registration_failures(185);

}
namespace test_only {
  /**
   * generated from test_only.bad_code
   */
  /**
   * Number of times we encountered bad code.
     * This is a test-only metric.
   */
  constexpr impl::CounterMetric bad_code(186);

  /**
   * generated from test_only.can_we_flag_it
   */
  /**
   * Test metric for a boolean.
     * This is a test-only metric.
   */
  constexpr impl::BooleanMetric can_we_flag_it(187);

  /**
   * generated from test_only.can_we_time_it
   */
  /**
   * Test metric for a timespan.
     * This is a test-only metric.
   */
  constexpr impl::TimespanMetric can_we_time_it(188);

  /**
   * generated from test_only.cheesy_string
   */
  /**
   * Only the cheesiest of strings.
     * This is a test-only metric.
   */
  constexpr impl::StringMetric cheesy_string(189);

  /**
   * generated from test_only.cheesy_string_list
   */
  /**
   * Only the cheesiest of strings. In list form!
     * This is a test-only metric.
   */
  constexpr impl::StringListMetric cheesy_string_list(190);

  /**
   * generated from test_only.do_you_remember
   */
  /**
   * They say it's the second thing to go.
     * This is a test-only metric.
   */
  constexpr impl::MemoryDistributionMetric do_you_remember(191);

  /**
   * generated from test_only.mabels_balloon_labels
   */
  enum class MabelsBalloonLabelsLabel: uint16_t {
      eCelebratory = 0,
      eCelebratoryAndSnarky = 1,
      e__Other__,
    };
  /**
   * How does Mabel label her balloons?
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, MabelsBalloonLabelsLabel> mabels_balloon_labels(192);

  /**
   * generated from test_only.mabels_balloon_strings
   */
  /**
   * What do the labeled Mabel's liked balloons' strings say?
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> mabels_balloon_strings(193);

  /**
   * generated from test_only.mabels_bathroom_counters
   */
  /**
   * Counts Mabels labeled by their bathroom counters.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> mabels_bathroom_counters(194);

  /**
   * generated from test_only.mabels_kitchen_counters
   */
  /**
   * Counts Mabels labeled by their kitchen counters.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> mabels_kitchen_counters(195);

  /**
   * generated from test_only.mabels_label_maker
   */
  /**
   * Mabel just got a label maker and wants to party like it's
     * 1999.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::StringMetric, DynamicLabel> mabels_label_maker(196);

  /**
   * generated from test_only.mabels_labeled_counters
   */
  enum class MabelsLabeledCountersLabel: uint16_t {
      eNextToTheFridge = 0,
      eClean = 1,
      e__Other__,
    };
  /**
   * Counts Mabels labeled by their kitchen counters.
     * Now with static labels.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::CounterMetric, MabelsLabeledCountersLabel> mabels_labeled_counters(197);

  /**
   * generated from test_only.mabels_like_balloons
   */
  /**
   * Does the labeled Mabel like balloons?
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> mabels_like_balloons(198);

  /**
   * generated from test_only.mabels_like_labeled_balloons
   */
  enum class MabelsLikeLabeledBalloonsLabel: uint16_t {
      eWater = 0,
      eBirthdayParty = 1,
      e__Other__,
    };
  /**
   * Does the labeled Mabel like balloons?
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, MabelsLikeLabeledBalloonsLabel> mabels_like_labeled_balloons(199);

  /**
   * generated from test_only.meaning_of_life
   */
  /**
   * Measures the one true answer to the Ultimate Question of Life,
     * the Universe, and Everything.
     * Approximately.
     * This is a test-only metric.
   */
  constexpr impl::QuantityMetric meaning_of_life(200);

  /**
   * generated from test_only.mirror_time
   */
  /**
   * Mirrored metric for a timespan.
     * This is a test-only metric.
   */
  constexpr impl::TimespanMetric mirror_time(201);

  /**
   * generated from test_only.mirror_time_nanos
   */
  /**
   * Mirrored metric for a timespan.
     * This is a test-only metric.
   */
  constexpr impl::TimespanMetric mirror_time_nanos(202);

  /**
   * generated from test_only.mirrors_for_labeled_bools
   */
  /**
   * Mirrored metric.
     * This is a test-only metric.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DynamicLabel> mirrors_for_labeled_bools(203);

  /**
   * generated from test_only.one_ping_one_bool
   */
  /**
   * One bool for one ping only.
     * This is a test-only metric.
   */
  constexpr impl::BooleanMetric one_ping_one_bool(204);

  /**
   * generated from test_only.what_a_date
   */
  /**
   * ...To be writing FOG code. This is a test-only metric.
   */
  constexpr impl::DatetimeMetric what_a_date(205);

  /**
   * generated from test_only.what_id_it
   */
  /**
   * Just a UUID.
     * This is a test-only metric.
   */
  constexpr impl::UuidMetric what_id_it(206);

  /**
   * generated from test_only.what_time_is_it
   */
  /**
   * Adheres to at least two of the top ten fallacies programmers believe
     * about time.
     * This is a test-only metric.
   */
  constexpr impl::TimingDistributionMetric what_time_is_it(207);

}
namespace test_only_ipc {
  /**
   * generated from test_only.ipc.a_bool
   */
  /**
   * This is a test-only metric.
     * Just flagging things.
   */
  constexpr impl::BooleanMetric a_bool(208);

  /**
   * generated from test_only.ipc.a_counter
   */
  /**
   * This is a test-only metric.
     * Just counting things.
   */
  constexpr impl::CounterMetric a_counter(209);

  /**
   * generated from test_only.ipc.a_custom_dist
   */
  /**
   * This is a test-only metric.
     * Just measuring samples.
   */
  constexpr impl::CustomDistributionMetric a_custom_dist(210);

  /**
   * generated from test_only.ipc.a_date
   */
  /**
   * This is a test-only metric.
     * Just putting things on the calendar.
   */
  constexpr impl::DatetimeMetric a_date(211);

  /**
   * generated from test_only.ipc.a_labeled_counter
   */
  /**
   * This is a test-only metric.
     * Just counting labeled things.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> a_labeled_counter(212);

  /**
   * generated from test_only.ipc.a_memory_dist
   */
  /**
   * This is a test-only metric.
     * Just measuring memory.
   */
  constexpr impl::MemoryDistributionMetric a_memory_dist(213);

  /**
   * generated from test_only.ipc.a_quantity
   */
  /**
   * This is a test-only metric.
     * Just quantifying things.
   */
  constexpr impl::QuantityMetric a_quantity(214);

  /**
   * generated from test_only.ipc.a_string
   */
  /**
   * This is a test-only metric.
     * Just setting some strings.
   */
  constexpr impl::StringMetric a_string(215);

  /**
   * generated from test_only.ipc.a_string_list
   */
  /**
   * This is a test-only metric.
     * Just appending some strings.
   */
  constexpr impl::StringListMetric a_string_list(216);

  /**
   * generated from test_only.ipc.a_text
   */
  /**
   * This is a test-only metric.
     * For holding Text data.
   */
  constexpr impl::TextMetric a_text(217);

  /**
   * generated from test_only.ipc.a_timing_dist
   */
  /**
   * This is a test-only metric.
     * Just measuring time.
   */
  constexpr impl::TimingDistributionMetric a_timing_dist(218);

  /**
   * generated from test_only.ipc.a_url
   */
  /**
   * This is a test-only metric.
     * Just setting some Urls.
   */
  constexpr impl::UrlMetric a_url(219);

  /**
   * generated from test_only.ipc.a_uuid
   */
  /**
   * This is a test-only metric.
     * Just recording some unique identifiers.
   */
  constexpr impl::UuidMetric a_uuid(220);

  /**
   * generated from test_only.ipc.an_event
   */
    struct AnEventExtra {
      mozilla::Maybe<nsCString> extra1;
      mozilla::Maybe<nsCString> extra2;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (extra1) {
          extraKeys.AppendElement()->AssignASCII("extra1");
          extraValues.EmplaceBack(extra1.value());
        }
        if (extra2) {
          extraKeys.AppendElement()->AssignASCII("extra2");
          extraValues.EmplaceBack(extra2.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * This is a test-only metric.
     * Just recording some events.
   */
  constexpr impl::EventMetric<AnEventExtra> an_event(221);

  /**
   * generated from test_only.ipc.an_external_denominator
   */
  /**
   * This is a test-only metric.
     * A denominator not from around here.
   */
  constexpr impl::DenominatorMetric an_external_denominator(222);

  /**
   * generated from test_only.ipc.another_labeled_counter
   */
  /**
   * This is a test-only metric.
     * Just another metric counting labeled things.
   */
  constexpr impl::Labeled<impl::CounterMetric, DynamicLabel> another_labeled_counter(223);

  /**
   * generated from test_only.ipc.event_with_extra
   */
    struct EventWithExtraExtra {
      mozilla::Maybe<nsCString> extra1;
      mozilla::Maybe<uint32_t> extra2;
      mozilla::Maybe<bool> extra3LongerName;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (extra1) {
          extraKeys.AppendElement()->AssignASCII("extra1");
          extraValues.EmplaceBack(extra1.value());
        }
        if (extra2) {
          extraKeys.AppendElement()->AssignASCII("extra2");
          extraValues.EmplaceBack(nsPrintfCString("%d", extra2.value()));
        }
        if (extra3LongerName) {
          extraKeys.AppendElement()->AssignASCII("extra3_longer_name");
          extraValues.AppendElement()->AssignASCII(extra3LongerName.value() ? "true" : "false");
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * This is a test-only metric.
     * Just recording some events.
   */
  constexpr impl::EventMetric<EventWithExtraExtra> event_with_extra(224);

  /**
   * generated from test_only.ipc.irate
   */
  /**
   * This is a test-only metric.
     * A rate that isn't happy about it.
   */
  constexpr impl::RateMetric irate(225);

  /**
   * generated from test_only.ipc.no_extra_event
   */
  /**
   * This is a test-only metric.
     * Just recording some events without the extra fuss.
   */
  constexpr impl::EventMetric<NoExtraKeys> no_extra_event(226);

  /**
   * generated from test_only.ipc.rate_with_external_denominator
   */
  /**
   * This is a test-only metric.
     * A rate with a denominator that is Out There.
   */
  constexpr impl::NumeratorMetric rate_with_external_denominator(227);

}
namespace test_only_jog {
  /**
   * generated from test_only.jog.a_counter
   */
  /**
   * This is a test-only metric.
     * Just counting things.
     * Tied closely to test_jog_name_collision.
   */
  constexpr impl::CounterMetric a_counter(228);

  /**
   * generated from test_only.jog.an_event
   */
    struct AnEventExtra {
      mozilla::Maybe<nsCString> extra1;
      mozilla::Maybe<nsCString> extra2;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (extra1) {
          extraKeys.AppendElement()->AssignASCII("extra1");
          extraValues.EmplaceBack(extra1.value());
        }
        if (extra2) {
          extraKeys.AppendElement()->AssignASCII("extra2");
          extraValues.EmplaceBack(extra2.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * This is a test-only metric.
     * Just recording some events.
     * Tied closely to test_jog_name_collision.
   */
  constexpr impl::EventMetric<AnEventExtra> an_event(229);

}
namespace nimbus_events {
  /**
   * generated from nimbus_events.enroll_failed
   */
    struct EnrollFailedExtra {
      mozilla::Maybe<nsCString> branch;
      mozilla::Maybe<nsCString> experiment;
      mozilla::Maybe<nsCString> reason;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (branch) {
          extraKeys.AppendElement()->AssignASCII("branch");
          extraValues.EmplaceBack(branch.value());
        }
        if (experiment) {
          extraKeys.AppendElement()->AssignASCII("experiment");
          extraValues.EmplaceBack(experiment.value());
        }
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when an enrollment fails, including the reason for the failure.
   */
  constexpr impl::EventMetric<EnrollFailedExtra> enroll_failed(230);

  /**
   * generated from nimbus_events.enrollment
   */
    struct EnrollmentExtra {
      mozilla::Maybe<nsCString> branch;
      mozilla::Maybe<nsCString> enrollmentId;
      mozilla::Maybe<nsCString> experiment;
      mozilla::Maybe<nsCString> experimentType;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (branch) {
          extraKeys.AppendElement()->AssignASCII("branch");
          extraValues.EmplaceBack(branch.value());
        }
        if (enrollmentId) {
          extraKeys.AppendElement()->AssignASCII("enrollment_id");
          extraValues.EmplaceBack(enrollmentId.value());
        }
        if (experiment) {
          extraKeys.AppendElement()->AssignASCII("experiment");
          extraValues.EmplaceBack(experiment.value());
        }
        if (experimentType) {
          extraKeys.AppendElement()->AssignASCII("experiment_type");
          extraValues.EmplaceBack(experimentType.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user has met the conditions and is first bucketed into an
     * experiment (i.e. targeting matched and they were randomized into a bucket and
     * branch of the experiment). Expected a maximum of once per experiment per user.
   */
  constexpr impl::EventMetric<EnrollmentExtra> enrollment(231);

  /**
   * generated from nimbus_events.exposure
   */
    struct ExposureExtra {
      mozilla::Maybe<nsCString> branch;
      mozilla::Maybe<nsCString> experiment;
      mozilla::Maybe<nsCString> featureId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (branch) {
          extraKeys.AppendElement()->AssignASCII("branch");
          extraValues.EmplaceBack(branch.value());
        }
        if (experiment) {
          extraKeys.AppendElement()->AssignASCII("experiment");
          extraValues.EmplaceBack(experiment.value());
        }
        if (featureId) {
          extraKeys.AppendElement()->AssignASCII("feature_id");
          extraValues.EmplaceBack(featureId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when a user actually observes an experimental treatment, or would have
     * observed an experimental treatment if they had been in a branch that would have
     * shown one.
   */
  constexpr impl::EventMetric<ExposureExtra> exposure(232);

  /**
   * generated from nimbus_events.unenroll_failed
   */
    struct UnenrollFailedExtra {
      mozilla::Maybe<nsCString> experiment;
      mozilla::Maybe<nsCString> reason;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (experiment) {
          extraKeys.AppendElement()->AssignASCII("experiment");
          extraValues.EmplaceBack(experiment.value());
        }
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when an unenrollment fails, including the reason for the failure.
   */
  constexpr impl::EventMetric<UnenrollFailedExtra> unenroll_failed(233);

  /**
   * generated from nimbus_events.unenrollment
   */
    struct UnenrollmentExtra {
      mozilla::Maybe<nsCString> branch;
      mozilla::Maybe<nsCString> enrollmentId;
      mozilla::Maybe<nsCString> experiment;
      mozilla::Maybe<nsCString> reason;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (branch) {
          extraKeys.AppendElement()->AssignASCII("branch");
          extraValues.EmplaceBack(branch.value());
        }
        if (enrollmentId) {
          extraKeys.AppendElement()->AssignASCII("enrollment_id");
          extraValues.EmplaceBack(enrollmentId.value());
        }
        if (experiment) {
          extraKeys.AppendElement()->AssignASCII("experiment");
          extraValues.EmplaceBack(experiment.value());
        }
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when either telemetry is disabled, or the experiment has run for its
     * designed duration (i.e. it is no longer present in the Nimbus Remote Settings
     * collection)
   */
  constexpr impl::EventMetric<UnenrollmentExtra> unenrollment(234);

  /**
   * generated from nimbus_events.validation_failed
   */
    struct ValidationFailedExtra {
      mozilla::Maybe<nsCString> branch;
      mozilla::Maybe<nsCString> experiment;
      mozilla::Maybe<nsCString> feature;
      mozilla::Maybe<nsCString> l10nIds;
      mozilla::Maybe<nsCString> locale;
      mozilla::Maybe<nsCString> reason;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (branch) {
          extraKeys.AppendElement()->AssignASCII("branch");
          extraValues.EmplaceBack(branch.value());
        }
        if (experiment) {
          extraKeys.AppendElement()->AssignASCII("experiment");
          extraValues.EmplaceBack(experiment.value());
        }
        if (feature) {
          extraKeys.AppendElement()->AssignASCII("feature");
          extraValues.EmplaceBack(feature.value());
        }
        if (l10nIds) {
          extraKeys.AppendElement()->AssignASCII("l10n_ids");
          extraValues.EmplaceBack(l10nIds.value());
        }
        if (locale) {
          extraKeys.AppendElement()->AssignASCII("locale");
          extraValues.EmplaceBack(locale.value());
        }
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * This records when validation of a recipe fails.
   */
  constexpr impl::EventMetric<ValidationFailedExtra> validation_failed(235);

}
namespace pdfjs {
  /**
   * generated from pdfjs.buttons
   */
  enum class ButtonsLabel: uint16_t {
      ePresentationMode = 0,
      ePresentationModeKeyboard = 1,
      eViewBookmark = 2,
      eFirstPage = 3,
      eLastPage = 4,
      ePageRotateCw = 5,
      ePageRotateCcw = 6,
      eCursorSelectTool = 7,
      eCursorHandTool = 8,
      eScrollPage = 9,
      eScrollVertical = 10,
      eScrollHorizontal = 11,
      eScrollWrapped = 12,
      eSpreadNone = 13,
      eSpreadOdd = 14,
      eSpreadEven = 15,
      eDocumentProperties = 16,
      e__Other__,
    };
  /**
   * Counts the number of times some actions are executed in the PDF viewer.
   */
  constexpr impl::Labeled<impl::CounterMetric, ButtonsLabel> buttons(236);

  /**
   * generated from pdfjs.editing
   */
  enum class EditingLabel: uint16_t {
      eInk = 0,
      eFreetext = 1,
      eSave = 2,
      ePrint = 3,
      e__Other__,
    };
  /**
   * Counts the number of times some PDF editing features are used.
   */
  constexpr impl::Labeled<impl::CounterMetric, EditingLabel> editing(237);

  /**
   * generated from pdfjs.geckoview
   */
  enum class GeckoviewLabel: uint16_t {
      eDownloadTapped = 0,
      eOpenInAppTapped = 1,
      eOpenInAppJustOnce = 2,
      eOpenInAppAlways = 3,
      eDownloadFailed = 4,
      eDownloadSucceeded = 5,
      eSaveAsPdfTapped = 6,
      e__Other__,
    };
  /**
   * Counts the number of times some actions are executed in the PDF viewer.
   */
  constexpr impl::Labeled<impl::CounterMetric, GeckoviewLabel> geckoview(238);

  /**
   * generated from pdfjs.time_to_view
   */
  /**
   * Time spent to display first page in PDF Viewer (ms).
   */
  constexpr impl::CustomDistributionMetric time_to_view(239);

  /**
   * generated from pdfjs.used
   */
  /**
   * How many times PDF Viewer was used.
   */
  constexpr impl::CounterMetric used(240);

}
namespace power {
  /**
   * generated from power.cpu_time_bogus_values
   */
  /**
   * Impossibly large CPU time values that were discarded.
   */
  constexpr impl::CounterMetric cpu_time_bogus_values(241);

  /**
   * generated from power.cpu_time_per_process_type_ms
   */
  enum class CpuTimePerProcessTypeMsLabel: uint16_t {
      eParentActive = 0,
      eParentActivePlayingAudio = 1,
      eParentActivePlayingVideo = 2,
      eParentInactive = 3,
      eParentInactivePlayingAudio = 4,
      eParentInactivePlayingVideo = 5,
      ePrealloc = 6,
      ePrivilegedabout = 7,
      eRdd = 8,
      eSocket = 9,
      eWebBackground = 10,
      eWebBackgroundPerceivable = 11,
      eWebForeground = 12,
      eExtension = 13,
      eGpu = 14,
      eGmplugin = 15,
      eUtility = 16,
      e__Other__,
    };
  /**
   * CPU time used by each process type in ms.
   */
  constexpr impl::Labeled<impl::CounterMetric, CpuTimePerProcessTypeMsLabel> cpu_time_per_process_type_ms(242);

  /**
   * generated from power.cpu_time_per_tracker_type_ms
   */
  enum class CpuTimePerTrackerTypeMsLabel: uint16_t {
      eAd = 0,
      eAnalytics = 1,
      eCryptomining = 2,
      eFingerprinting = 3,
      eSocial = 4,
      eUnknown = 5,
      e__Other__,
    };
  /**
   * CPU time used by content processes used only for tracking resources, labeled by
     * the category of the tracker.
   */
  constexpr impl::Labeled<impl::CounterMetric, CpuTimePerTrackerTypeMsLabel> cpu_time_per_tracker_type_ms(243);

  /**
   * generated from power.gpu_time_bogus_values
   */
  /**
   * Impossibly large GPU time values that were discarded.
   */
  constexpr impl::CounterMetric gpu_time_bogus_values(244);

  /**
   * generated from power.gpu_time_per_process_type_ms
   */
  enum class GpuTimePerProcessTypeMsLabel: uint16_t {
      eParentActive = 0,
      eParentActivePlayingAudio = 1,
      eParentActivePlayingVideo = 2,
      eParentInactive = 3,
      eParentInactivePlayingAudio = 4,
      eParentInactivePlayingVideo = 5,
      ePrealloc = 6,
      ePrivilegedabout = 7,
      eRdd = 8,
      eSocket = 9,
      eWebBackground = 10,
      eWebBackgroundPerceivable = 11,
      eWebForeground = 12,
      eExtension = 13,
      eGpu = 14,
      eGmplugin = 15,
      eUtility = 16,
      e__Other__,
    };
  /**
   * GPU time used by each process type in ms.
   */
  constexpr impl::Labeled<impl::CounterMetric, GpuTimePerProcessTypeMsLabel> gpu_time_per_process_type_ms(245);

  /**
   * generated from power.total_cpu_time_ms
   */
  /**
   * Total CPU time used by all processes in ms.
   */
  constexpr impl::CounterMetric total_cpu_time_ms(246);

  /**
   * generated from power.total_gpu_time_ms
   */
  /**
   * Total GPU time used by all processes in ms.
   */
  constexpr impl::CounterMetric total_gpu_time_ms(247);

  /**
   * generated from power.total_thread_wakeups
   */
  /**
   * How many times threads woke up and could have woken up a CPU core.
   */
  constexpr impl::CounterMetric total_thread_wakeups(248);

  /**
   * generated from power.wakeups_per_process_type
   */
  enum class WakeupsPerProcessTypeLabel: uint16_t {
      eParentActive = 0,
      eParentActivePlayingAudio = 1,
      eParentActivePlayingVideo = 2,
      eParentInactive = 3,
      eParentInactivePlayingAudio = 4,
      eParentInactivePlayingVideo = 5,
      ePrealloc = 6,
      ePrivilegedabout = 7,
      eRdd = 8,
      eSocket = 9,
      eWebBackground = 10,
      eWebBackgroundPerceivable = 11,
      eWebForeground = 12,
      eExtension = 13,
      eGpu = 14,
      eGmplugin = 15,
      eUtility = 16,
      e__Other__,
    };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down
     * by process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, WakeupsPerProcessTypeLabel> wakeups_per_process_type(249);

}
namespace power_battery {
  /**
   * generated from power.battery.percentage_when_user_active
   */
  /**
   * Records how many percent of battery was available for each period of user
     * activity.
   */
  constexpr impl::CustomDistributionMetric percentage_when_user_active(250);

}
namespace power_cpu_ms_per_thread {
  /**
   * generated from power.cpu_ms_per_thread.content_background
   */
  enum class ContentBackgroundLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a
     * given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ContentBackgroundLabel> content_background(251);

  /**
   * generated from power.cpu_ms_per_thread.content_foreground
   */
  enum class ContentForegroundLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a
     * given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ContentForegroundLabel> content_foreground(252);

  /**
   * generated from power.cpu_ms_per_thread.gpu_process
   */
  enum class GpuProcessLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a
     * given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, GpuProcessLabel> gpu_process(253);

  /**
   * generated from power.cpu_ms_per_thread.parent_active
   */
  enum class ParentActiveLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a
     * given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ParentActiveLabel> parent_active(254);

  /**
   * generated from power.cpu_ms_per_thread.parent_inactive
   */
  enum class ParentInactiveLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many miliseconds of CPU time were used. Broken down by thread name for a
     * given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ParentInactiveLabel> parent_inactive(255);

}
namespace power_wakeups_per_thread {
  /**
   * generated from power.wakeups_per_thread.content_background
   */
  enum class ContentBackgroundLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down
     * by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ContentBackgroundLabel> content_background(256);

  /**
   * generated from power.wakeups_per_thread.content_foreground
   */
  enum class ContentForegroundLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down
     * by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ContentForegroundLabel> content_foreground(257);

  /**
   * generated from power.wakeups_per_thread.gpu_process
   */
  enum class GpuProcessLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down
     * by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, GpuProcessLabel> gpu_process(258);

  /**
   * generated from power.wakeups_per_thread.parent_active
   */
  enum class ParentActiveLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down
     * by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ParentActiveLabel> parent_active(259);

  /**
   * generated from power.wakeups_per_thread.parent_inactive
   */
  enum class ParentInactiveLabel: uint16_t {
      eAsynclogger = 0,
      eAudioipc = 1,
      eAudioipcCallbackRpc = 2,
      eAudioipcClientCallback = 3,
      eAudioipcClientRpc = 4,
      eAudioipcDevicecollectionRpc = 5,
      eAudioipcServerCallback = 6,
      eAudioipcServerRpc = 7,
      eBackgroundthreadpool = 8,
      eBgiothreadpool = 9,
      eBgreadurls = 10,
      eBhmgrMonitor = 11,
      eBhmgrProcessor = 12,
      eCamerasIpc = 13,
      eCapturethread = 14,
      eClassifierUpdate = 15,
      eComMta = 16,
      eCompositor = 17,
      eCookie = 18,
      eCubeboperation = 19,
      eDatachannelIo = 20,
      eDnsResolver = 21,
      eDomWorker = 22,
      eDomcachethread = 23,
      eExtensionprotocolhandler = 24,
      eFontLoader = 25,
      eFontenumthread = 26,
      eFsBroker = 27,
      eGeckomain = 28,
      eGmpthread = 29,
      eGraphrunner = 30,
      eHtml5Parser = 31,
      eImagebridgechld = 32,
      eImageio = 33,
      eIndexeddb = 34,
      eInitfontlist = 35,
      eInotifyeventthread = 36,
      eIpcIOChild = 37,
      eIpcIOParent = 38,
      eIpcLaunch = 39,
      eIpdlBackground = 40,
      eJsWatchdog = 41,
      eJumpList = 42,
      eLibwebrtcmodulethread = 43,
      eLinkMonitor = 44,
      eLsThread = 45,
      eMediacache = 46,
      eMediadecoderstatemachine = 47,
      eMediapdecoder = 48,
      eMediasupervisor = 49,
      eMediatimer = 50,
      eMediatrackgrph = 51,
      eMemorypoller = 52,
      eMozstorage = 53,
      eMtransport = 54,
      eNetlinkMonitor = 55,
      ePacerthread = 56,
      ePermission = 57,
      ePlayeventsound = 58,
      eProcesshangmon = 59,
      eProfilerchild = 60,
      eProxyresolution = 61,
      eQuotamanagerIo = 62,
      eRegisterfonts = 63,
      eRemotebackbuffer = 64,
      eRemotelzystream = 65,
      eRemvidchild = 66,
      eRenderer = 67,
      eSandboxreporter = 68,
      eSavescripts = 69,
      eSocketThread = 70,
      eSoftwarevsyncthread = 71,
      eSslCert = 72,
      eStartupcache = 73,
      eStreamtrans = 74,
      eStylethread = 75,
      eSwcomposite = 76,
      eTaskcontroller = 77,
      eTimer = 78,
      eToastbgthread = 79,
      eTrrBackground = 80,
      eUntrustedModules = 81,
      eUrlClassifier = 82,
      eVideocapture = 83,
      eVsynciothread = 84,
      eWebrtccallthread = 85,
      eWebrtcworker = 86,
      eWincompositor = 87,
      eWindowsvsyncthread = 88,
      eWinwindowocclusioncalc = 89,
      eWorkerLauncher = 90,
      eWrrenderbackend = 91,
      eWrscenebuilder = 92,
      eWrscenebuilderlp = 93,
      eWrworker = 94,
      eWrworkerlp = 95,
      e__Other__,
    };
  /**
   * How many times threads woke up and could have woken up a CPU core. Broken down
     * by thread name for a given process type.
   */
  constexpr impl::Labeled<impl::CounterMetric, ParentInactiveLabel> parent_inactive(260);

}
namespace search_engine_default {
  /**
   * generated from search.engine.default.changed
   */
    struct ChangedExtra {
      mozilla::Maybe<nsCString> changeSource;
      mozilla::Maybe<nsCString> newDisplayName;
      mozilla::Maybe<nsCString> newEngineId;
      mozilla::Maybe<nsCString> newLoadPath;
      mozilla::Maybe<nsCString> newSubmissionUrl;
      mozilla::Maybe<nsCString> previousEngineId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (changeSource) {
          extraKeys.AppendElement()->AssignASCII("change_source");
          extraValues.EmplaceBack(changeSource.value());
        }
        if (newDisplayName) {
          extraKeys.AppendElement()->AssignASCII("new_display_name");
          extraValues.EmplaceBack(newDisplayName.value());
        }
        if (newEngineId) {
          extraKeys.AppendElement()->AssignASCII("new_engine_id");
          extraValues.EmplaceBack(newEngineId.value());
        }
        if (newLoadPath) {
          extraKeys.AppendElement()->AssignASCII("new_load_path");
          extraValues.EmplaceBack(newLoadPath.value());
        }
        if (newSubmissionUrl) {
          extraKeys.AppendElement()->AssignASCII("new_submission_url");
          extraValues.EmplaceBack(newSubmissionUrl.value());
        }
        if (previousEngineId) {
          extraKeys.AppendElement()->AssignASCII("previous_engine_id");
          extraValues.EmplaceBack(previousEngineId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the default search engine is changed.
   */
  constexpr impl::EventMetric<ChangedExtra> changed(261);

  /**
   * generated from search.engine.default.display_name
   */
  /**
   * The display name of the user's default engine.
   */
  constexpr impl::StringMetric display_name(262);

  /**
   * generated from search.engine.default.engine_id
   */
  /**
   * The telemetry id of the search engine.
     * For application provided engines, this is either supplied by the
     * configuration or from the first part of the associated WebExtension Id.
     * For other engines, this is `other-<extensionName>`.
   */
  constexpr impl::StringMetric engine_id(263);

  /**
   * generated from search.engine.default.load_path
   */
  /**
   * A path relating to where the search engine was installed/loaded from.
     * For example:
     *   `[addon]<extension id>` for a WebExtension based
     *   engine.
     *   `[https]developer.mozilla.org/mdn-web-docs.xml` for an OpenSearch based
     *   engine.
     * Note: this metric is truncated at 100 characters.
   */
  constexpr impl::StringMetric load_path(264);

  /**
   * generated from search.engine.default.submission_url
   */
  /**
   * The submission URL of the default engine. This is only reported in the
     * cases where:
     *   The engine is an application provided engine.
     *   The engine has the same name as an application provided engine.
     *   The engine matches one of a specific list of well known search engines.
   */
  constexpr impl::UrlMetric submission_url(265);

  /**
   * generated from search.engine.default.verified
   */
  /**
   * The verified status of the search engine.
     * For application provided engines, this will always be `default`.
     * For other engines this will either be `verified` or `unverified` depending
     * on if the loadPathHash is valid.
   */
  constexpr impl::StringMetric verified(266);

}
namespace search_engine_private {
  /**
   * generated from search.engine.private.changed
   */
    struct ChangedExtra {
      mozilla::Maybe<nsCString> changeSource;
      mozilla::Maybe<nsCString> newDisplayName;
      mozilla::Maybe<nsCString> newEngineId;
      mozilla::Maybe<nsCString> newLoadPath;
      mozilla::Maybe<nsCString> newSubmissionUrl;
      mozilla::Maybe<nsCString> previousEngineId;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (changeSource) {
          extraKeys.AppendElement()->AssignASCII("change_source");
          extraValues.EmplaceBack(changeSource.value());
        }
        if (newDisplayName) {
          extraKeys.AppendElement()->AssignASCII("new_display_name");
          extraValues.EmplaceBack(newDisplayName.value());
        }
        if (newEngineId) {
          extraKeys.AppendElement()->AssignASCII("new_engine_id");
          extraValues.EmplaceBack(newEngineId.value());
        }
        if (newLoadPath) {
          extraKeys.AppendElement()->AssignASCII("new_load_path");
          extraValues.EmplaceBack(newLoadPath.value());
        }
        if (newSubmissionUrl) {
          extraKeys.AppendElement()->AssignASCII("new_submission_url");
          extraValues.EmplaceBack(newSubmissionUrl.value());
        }
        if (previousEngineId) {
          extraKeys.AppendElement()->AssignASCII("previous_engine_id");
          extraValues.EmplaceBack(previousEngineId.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Recorded when the default search engine is changed
   */
  constexpr impl::EventMetric<ChangedExtra> changed(267);

  /**
   * generated from search.engine.private.display_name
   */
  /**
   * The display name of the user's default engine.
     * If this string is an empty string (`""`), this means that one or both of
     * the preferences `browser.search.separatePrivateDefault` and
     * `browser.search.separatePrivateDefault.ui.enabled` are set to false.
     * It is possible that the user selects the same private engine as for the
     * default engine, and hence both versions of these fields will be filled in.
   */
  constexpr impl::StringMetric display_name(268);

  /**
   * generated from search.engine.private.engine_id
   */
  /**
   * The telemetry id of the search engine.
     * For application provided engines, this is either supplied by the
     * configuration or from the first part of the associated WebExtension Id.
     * For other engines, this is `other-<extensionName>`.
     * If this string is an empty string (`""`), this means that one or both of
     * the preferences `browser.search.separatePrivateDefault` and
     * `browser.search.separatePrivateDefault.ui.enabled` are set to false.
     * It is possible that the user selects the same private engine as for the
     * default engine, and hence both versions of these fields will be filled in.
   */
  constexpr impl::StringMetric engine_id(269);

  /**
   * generated from search.engine.private.load_path
   */
  /**
   * A path relating to where the search engine was installed/loaded from.
     * For example:
     *   `[addon]<extension id>` for a WebExtension based
     *   engine.
     *   `[https]developer.mozilla.org/mdn-web-docs.xml` for an OpenSearch based
     *   engine.
     * Note: this metric is truncated at 100 characters.
     * If this string is an empty string (`""`), this means that one or both of
     * the preferences `browser.search.separatePrivateDefault` and
     * `browser.search.separatePrivateDefault.ui.enabled` are set to false.
     * It is possible that the user selects the same private engine as for the
     * default engine, and hence both versions of these fields will be filled in.
   */
  constexpr impl::StringMetric load_path(270);

  /**
   * generated from search.engine.private.submission_url
   */
  /**
   * The submission URL of the default engine. This is only reported in the
     * cases where:
     *   The engine is an application provided engine.
     *   The engine has the same name as an application provided engine.
     *   The engine matches one of a specific list of well known search engines.
     * If this string is an empty string (`""`), this means that one or both of
     * the preferences `browser.search.separatePrivateDefault` and
     * `browser.search.separatePrivateDefault.ui.enabled` are set to false.
     * It is possible that the user selects the same private engine as for the
     * default engine, and hence both versions of these fields will be filled in.
   */
  constexpr impl::UrlMetric submission_url(271);

  /**
   * generated from search.engine.private.verified
   */
  /**
   * The verified status of the search engine.
     * For application provided engines, this will always be `default`.
     * For other engines this will either be `verified` or `unverified` depending
     * on if the loadPathHash is valid.
     * If this string is an empty string (`""`), this means that one or both of
     * the preferences `browser.search.separatePrivateDefault` and
     * `browser.search.separatePrivateDefault.ui.enabled` are set to false.
     * It is possible that the user selects the same private engine as for the
     * default engine, and hence both versions of these fields will be filled in.
   */
  constexpr impl::StringMetric verified(272);

}
namespace search_service {
  /**
   * generated from search.service.startup_time
   */
  /**
   * The time duration it takes for the search service to start up.
   */
  constexpr impl::TimingDistributionMetric startup_time(273);

}
namespace dap {
  /**
   * generated from dap.report_generation_status
   */
  enum class ReportGenerationStatusLabel: uint16_t {
      eSuccess = 0,
      eFailure = 1,
      e__Other__,
    };
  /**
   * The result of trying to generate a DAP report.
   */
  constexpr impl::Labeled<impl::CounterMetric, ReportGenerationStatusLabel> report_generation_status(274);

  /**
   * generated from dap.upload_status
   */
  enum class UploadStatusLabel: uint16_t {
      eSuccess = 0,
      eFailure = 1,
      e__Other__,
    };
  /**
   * The result of trying to upload a report to the DAP server.
   */
  constexpr impl::Labeled<impl::CounterMetric, UploadStatusLabel> upload_status(275);

}
namespace legacy_telemetry {
  /**
   * generated from legacy.telemetry.client_id
   */
  /**
   * The client_id according to Telemetry.
     * Might not always have a value due to being too early for it to have
     * loaded.
     * Value may be the canary client id `c0ffeec0-ffee-c0ff-eec0-ffeec0ffeec0`
     * in pings near when the data upload pref is disabled (if Telemetry gets
     * to go first), or between when a client_id has been removed and when it
     * has been regenerated.
     * Does not need to be sent in the Glean "deletion-request" ping.
   */
  constexpr impl::UuidMetric client_id(276);

}
namespace translations {
  /**
   * generated from translations.error
   */
    struct ErrorExtra {
      mozilla::Maybe<nsCString> reason;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (reason) {
          extraKeys.AppendElement()->AssignASCII("reason");
          extraValues.EmplaceBack(reason.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * The specific translations error that caused a full-page translation failure.
   */
  constexpr impl::EventMetric<ErrorExtra> error(277);

  /**
   * generated from translations.error_rate
   */
  /**
   * The rate of failed translations requests.
   */
  constexpr impl::NumeratorMetric error_rate(278);

  /**
   * generated from translations.requests_count
   */
  /**
   * The count of translation requests.
   */
  constexpr impl::DenominatorMetric requests_count(279);

  /**
   * generated from translations.translation_request
   */
    struct TranslationRequestExtra {
      mozilla::Maybe<bool> autoTranslate;
      mozilla::Maybe<nsCString> fromLanguage;
      mozilla::Maybe<nsCString> toLanguage;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (autoTranslate) {
          extraKeys.AppendElement()->AssignASCII("auto_translate");
          extraValues.AppendElement()->AssignASCII(autoTranslate.value() ? "true" : "false");
        }
        if (fromLanguage) {
          extraKeys.AppendElement()->AssignASCII("from_language");
          extraValues.EmplaceBack(fromLanguage.value());
        }
        if (toLanguage) {
          extraKeys.AppendElement()->AssignASCII("to_language");
          extraValues.EmplaceBack(toLanguage.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * Triggers when a full-page translation request is sent.
   */
  constexpr impl::EventMetric<TranslationRequestExtra> translation_request(280);

}
namespace first_startup {
  /**
   * generated from first_startup.elapsed
   */
  /**
   * Number of milliseconds the FirstStartup service took to run.
   */
  constexpr impl::QuantityMetric elapsed(281);

  /**
   * generated from first_startup.status_code
   */
  /**
   * Status of the FirstStartup service, which runs
     * post-install/early-startup in Firefox.
   */
  constexpr impl::QuantityMetric status_code(282);

}
namespace blocklist {
  /**
   * generated from blocklist.addon_block_change
   */
    struct AddonBlockChangeExtra {
      mozilla::Maybe<nsCString> addonVersion;
      mozilla::Maybe<nsCString> blocklistState;
      mozilla::Maybe<nsCString> hoursSince;
      mozilla::Maybe<nsCString> mlbfGeneration;
      mozilla::Maybe<nsCString> mlbfLastTime;
      mozilla::Maybe<nsCString> mlbfSource;
      mozilla::Maybe<nsCString> object;
      mozilla::Maybe<nsCString> signedDate;
      mozilla::Maybe<nsCString> value;

      std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
        nsTArray<nsCString> extraKeys;
        nsTArray<nsCString> extraValues;
        if (addonVersion) {
          extraKeys.AppendElement()->AssignASCII("addon_version");
          extraValues.EmplaceBack(addonVersion.value());
        }
        if (blocklistState) {
          extraKeys.AppendElement()->AssignASCII("blocklist_state");
          extraValues.EmplaceBack(blocklistState.value());
        }
        if (hoursSince) {
          extraKeys.AppendElement()->AssignASCII("hours_since");
          extraValues.EmplaceBack(hoursSince.value());
        }
        if (mlbfGeneration) {
          extraKeys.AppendElement()->AssignASCII("mlbf_generation");
          extraValues.EmplaceBack(mlbfGeneration.value());
        }
        if (mlbfLastTime) {
          extraKeys.AppendElement()->AssignASCII("mlbf_last_time");
          extraValues.EmplaceBack(mlbfLastTime.value());
        }
        if (mlbfSource) {
          extraKeys.AppendElement()->AssignASCII("mlbf_source");
          extraValues.EmplaceBack(mlbfSource.value());
        }
        if (object) {
          extraKeys.AppendElement()->AssignASCII("object");
          extraValues.EmplaceBack(object.value());
        }
        if (signedDate) {
          extraKeys.AppendElement()->AssignASCII("signed_date");
          extraValues.EmplaceBack(signedDate.value());
        }
        if (value) {
          extraKeys.AppendElement()->AssignASCII("value");
          extraValues.EmplaceBack(value.value());
        }
        return std::make_tuple(std::move(extraKeys), std::move(extraValues));
      }
    };
  /**
   * An add-on is blocked, or an installed add-on is unblocked. When an add-on
     * install/update is blocked, its installation is aborted and the add-on is no
     * longer listed in the activeAddons field of TelemetryEnvironment.
   */
  constexpr impl::EventMetric<AddonBlockChangeExtra> addon_block_change(283);

  /**
   * generated from blocklist.last_modified_rs_addons_mblf
   */
  /**
   * Keep track of the last time the "addons-bloomfilters" remotesetting blocklist
     * has been successfully updated.
   */
  constexpr impl::DatetimeMetric last_modified_rs_addons_mblf(284);

  /**
   * generated from blocklist.mlbf_generation_time
   */
  /**
   * Keep track of the generation time of the addon blocklist's bloom filter. This
     * marks the point in time until which signed add-ons are recognized by the
     * selected bloom filter from the addons-bloomfilters collection.
   */
  constexpr impl::DatetimeMetric mlbf_generation_time(285);

  /**
   * generated from blocklist.mlbf_source
   */
  /**
   * The source of the RemoteSettings attachment that holds the bloom filter.
     * Possible values are "dump_match", "cache_match",
     * "remote_match","dump_fallback", "cache_fallback", "unknown". "dump_match",
     * "cache_match" and "remote_match" are expected known-good values, and means that
     * the loaded bloomfilter matches the blocklist record in the RemoteSettings
     * collection. The prefix denotes the immediate source of the loaded data: "dump"
     * means packaged with the application, "remote" means a freshly downloaded
     * bloomfilter, "cache" means a previously downloaded bloomfilter. "dump_fallback"
     * and "cache_fallback" means that the last known bloomfilter was used, despite it
     * not matching the latest record in the RemoteSettings collection. In this case
     * the outdated bloomfilter is used as a fallback (e.g. because the latest version
     * cannot be downloaded). "unknown"  means that the bloomfilter cannot be loaded
     * at all. This can happen if the blocklist is disabled via preferences or
     * enterprise policies.
   */
  constexpr impl::StringMetric mlbf_source(286);

  /**
   * generated from blocklist.mlbf_stash_time_newest
   */
  /**
   * Keep track of the timestamp of the most recent stash of the addons blocklist.
     * Only meaningful when mlbf_enabled is true.
   */
  constexpr impl::DatetimeMetric mlbf_stash_time_newest(287);

  /**
   * generated from blocklist.mlbf_stash_time_oldest
   */
  /**
   * Keep track of the timestamp of the oldest stash of the addons blocklist. Only
     * meaningful when mlbf_enabled is true.
   */
  constexpr impl::DatetimeMetric mlbf_stash_time_oldest(288);

}
namespace update {
  /**
   * generated from update.auto_download
   */
  /**
   * Per-installation preference "app.update.auto": whether to fetch and install
     * updates without user intervention.
   */
  constexpr impl::BooleanMetric auto_download(289);

  /**
   * generated from update.background_update
   */
  /**
   * Per-installation preference "app.update.background.enabled": whether to fetch
     * and install updates in the background when Firefox is not running.
   */
  constexpr impl::BooleanMetric background_update(290);

  /**
   * generated from update.can_usually_apply_updates
   */
  /**
   * Whether or not the Update Service can usually download and install updates. See
     * `canUsuallyApplyUpdates` in https://searchfox.org/mozilla-
     * central/source/toolkit/mozapps/update/nsIUpdateService.idl.
   */
  constexpr impl::BooleanMetric can_usually_apply_updates(291);

  /**
   * generated from update.can_usually_check_for_updates
   */
  /**
   * Whether or not the Update Service can usually check for updates. See
     * `canUsuallyCheckForUpdates` in https://searchfox.org/mozilla-
     * central/source/toolkit/mozapps/update/nsIUpdateService.idl.
   */
  constexpr impl::BooleanMetric can_usually_check_for_updates(292);

  /**
   * generated from update.can_usually_stage_updates
   */
  /**
   * Whether the Update Service is usually able to stage updates. See
     * `canUsuallyStageUpdates` in https://searchfox.org/mozilla-
     * central/source/toolkit/mozapps/update/nsIUpdateService.idl.
   */
  constexpr impl::BooleanMetric can_usually_stage_updates(293);

  /**
   * generated from update.can_usually_use_bits
   */
  /**
   * On Windows, whether the Update Service can usually use BITS. See
     * `canUsuallyUseBits` in https://searchfox.org/mozilla-
     * central/source/toolkit/mozapps/update/nsIUpdateService.idl.
   */
  constexpr impl::BooleanMetric can_usually_use_bits(294);

  /**
   * generated from update.channel
   */
  /**
   * The update channel.
   */
  constexpr impl::StringMetric channel(295);

  /**
   * generated from update.enabled
   */
  /**
   * True when policies are disabled or when the "DisableAppUpdate" is not in
     * effect.
   */
  constexpr impl::BooleanMetric enabled(296);

  /**
   * generated from update.service_enabled
   */
  /**
   * Preference "app.update.service.enabled": whether the Mozilla Maintenance
     * Service is enabled.
   */
  constexpr impl::BooleanMetric service_enabled(297);

}
namespace startup {
  /**
   * generated from startup.is_restored_by_macos
   */
  /**
   * Recorded on every launch of a Firefox install on macOS, with a boolean value
     * indicating whether Firefox was restored by macOS or if it was manually launched
     * by a user.
   */
  constexpr impl::BooleanMetric is_restored_by_macos(298);

}
namespace timer_thread {
  /**
   * generated from timer_thread.timers_fired_per_wakeup
   */
  /**
   * How many timers were processed in a single wake-up of the Timer Thread.
   */
  constexpr impl::CustomDistributionMetric timers_fired_per_wakeup(299);

}

} // namespace mozilla::glean

#endif // mozilla_Metrics_h
