/* THIS FILE IS AUTOGENERATED FROM BiquadFilterNode.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_BiquadFilterNodeBinding_h
#define mozilla_dom_BiquadFilterNodeBinding_h

#include "AudioNodeBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"

namespace mozilla {
namespace dom {

class BiquadFilterNode;
struct BiquadFilterOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class BiquadFilterType : uint8_t {
  Lowpass,
  Highpass,
  Bandpass,
  Lowshelf,
  Highshelf,
  Peaking,
  Notch,
  Allpass,
  EndGuard_
};

namespace BiquadFilterTypeValues {
extern const EnumEntry strings[9];

static constexpr size_t Count = 8;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(BiquadFilterType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(BiquadFilterType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace BiquadFilterTypeValues

bool
ToJSValue(JSContext* aCx, BiquadFilterType aArgument, JS::MutableHandle<JS::Value> aValue);


struct BiquadFilterOptions : public AudioNodeOptions
{
  MOZ_INIT_OUTSIDE_CTOR float mQ;
  MOZ_INIT_OUTSIDE_CTOR float mDetune;
  MOZ_INIT_OUTSIDE_CTOR float mFrequency;
  MOZ_INIT_OUTSIDE_CTOR float mGain;
  MOZ_INIT_OUTSIDE_CTOR BiquadFilterType mType;

  BiquadFilterOptions();

  explicit inline BiquadFilterOptions(const FastDictionaryInitializer& )
    : AudioNodeOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  BiquadFilterOptions(BiquadFilterOptions&& aOther) = default;

  explicit inline BiquadFilterOptions(const BiquadFilterOptions& aOther)
    : AudioNodeOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  BiquadFilterOptions&
  operator=(const BiquadFilterOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, BiquadFilterOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBiquadFilterOptions : public BiquadFilterOptions
{
  inline FastBiquadFilterOptions()
    : BiquadFilterOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace BiquadFilterNode_Binding {

  typedef mozilla::dom::BiquadFilterNode NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::dom::BiquadFilterNode* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::BiquadFilterNode,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::BiquadFilterNode,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::BiquadFilterNode,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace BiquadFilterNode_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_BiquadFilterNodeBinding_h
