#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSActorTypeUtils = 8175,
  JSProcessActorChild = 8192,
  JSProcessActorParent = 8212,
  JSWindowActorChild = 8233,
  JSWindowActorParent = 8252,
  KeyEvent = 8272,
  KeyboardEvent = 8281,
  KeyframeEffect = 8295,
  L10nFileSource = 8310,
  L10nOverlays = 8325,
  L10nRegistry = 8338,
  LargestContentfulPaint = 8351,
  LegacyMozTCPSocket = 8374,
  Localization = 8393,
  Location = 8406,
  Lock = 8415,
  LockManager = 8420,
  MIDIAccess = 8432,
  MIDIConnectionEvent = 8443,
  MIDIInput = 8463,
  MIDIInputMap = 8473,
  MIDIMessageEvent = 8486,
  MIDIOutput = 8503,
  MIDIOutputMap = 8514,
  MIDIPort = 8528,
  MLS = 8537,
  MLSGroupView = 8541,
  MOZ_debug = 8554,
  MatchGlob = 8564,
  MatchPattern = 8574,
  MatchPatternSet = 8587,
  MathMLElement = 8603,
  MediaCapabilities = 8617,
  MediaControlService = 8635,
  MediaController = 8655,
  MediaDeviceInfo = 8671,
  MediaDevices = 8687,
  MediaElementAudioSourceNode = 8700,
  MediaEncryptedEvent = 8728,
  MediaError = 8748,
  MediaKeyError = 8759,
  MediaKeyMessageEvent = 8773,
  MediaKeySession = 8794,
  MediaKeyStatusMap = 8810,
  MediaKeyStatusMap_Iterator = 8828,
  MediaKeySystemAccess = 8855,
  MediaKeys = 8876,
  MediaList = 8886,
  MediaMetadata = 8896,
  MediaQueryList = 8910,
  MediaQueryListEvent = 8925,
  MediaRecorder = 8945,
  MediaRecorderErrorEvent = 8959,
  MediaSession = 8983,
  MediaSource = 8996,
  MediaStream = 9008,
  MediaStreamAudioDestinationNode = 9020,
  MediaStreamAudioSourceNode = 9052,
  MediaStreamError = 9079,
  MediaStreamEvent = 9096,
  MediaStreamTrack = 9113,
  MediaStreamTrackAudioSourceNode = 9130,
  MediaStreamTrackEvent = 9162,
  MerchantValidationEvent = 9184,
  MessageBroadcaster = 9208,
  MessageChannel = 9227,
  MessageEvent = 9242,
  MessageListenerManager = 9255,
  MessagePort = 9278,
  MessageSender = 9290,
  MimeType = 9304,
  MimeTypeArray = 9313,
  MouseEvent = 9327,
  MouseScrollEvent = 9338,
  MozCanvasPrintState = 9355,
  MozDocumentMatcher = 9375,
  MozDocumentObserver = 9394,
  MozQueryInterface = 9414,
  MozSharedMap = 9432,
  MozSharedMap_Iterator = 9445,
  MozSharedMapChangeEvent = 9467,
  MozStorageAsyncStatementParams = 9491,
  MozStorageStatementParams = 9522,
  MozStorageStatementRow = 9548,
  MozWritableSharedMap = 9571,
  MutationObserver = 9592,
  MutationRecord = 9609,
  NamedNodeMap = 9624,
  NavigateEvent = 9637,
  Navigation = 9651,
  NavigationActivation = 9662,
  NavigationCurrentEntryChangeEvent = 9683,
  NavigationDestination = 9717,
  NavigationHistoryEntry = 9739,
  NavigationPrecommitController = 9762,
  NavigationPreloadManager = 9792,
  NavigationTransition = 9817,
  Navigator = 9838,
  NavigatorLogin = 9848,
  NetworkInformation = 9863,
  Node = 9882,
  NodeFilter = 9887,
  NodeIterator = 9898,
  NodeList = 9911,
  Notification = 9920,
  NotificationEvent = 9933,
  NotifyPaintEvent = 9951,
  OES_draw_buffers_indexed = 9968,
  OES_element_index_uint = 9993,
  OES_fbo_render_mipmap = 10016,
  OES_standard_derivatives = 10038,
  OES_texture_float = 10063,
  OES_texture_float_linear = 10081,
  OES_texture_half_float = 10106,
  OES_texture_half_float_linear = 10129,
  OES_vertex_array_object = 10159,
  OVR_multiview2 = 10183,
  OfflineAudioCompletionEvent = 10198,
  OfflineAudioContext = 10226,
  OffscreenCanvas = 10246,
  OffscreenCanvasRenderingContext2D = 10262,
  Option = 10296,
  OscillatorNode = 10303,
  PageTransitionEvent = 10318,
  PaintRequest = 10338,
  PaintRequestList = 10351,
  PaintWorkletGlobalScope = 10368,
  PannerNode = 10392,
  ParentProcessMessageManager = 10403,
  Path2D = 10431,
  PathUtils = 10438,
  PaymentAddress = 10448,
  PaymentMethodChangeEvent = 10463,
  PaymentRequest = 10488,
  PaymentRequestUpdateEvent = 10503,
  PaymentResponse = 10529,
  PeerConnectionImpl = 10545,
  PeerConnectionObserver = 10564,
  Performance = 10587,
  PerformanceEntry = 10599,
  PerformanceEntryEvent = 10616,
  PerformanceEventTiming = 10638,
  PerformanceMark = 10661,
  PerformanceMeasure = 10677,
  PerformanceNavigation = 10696,
  PerformanceNavigationTiming = 10718,
  PerformanceObserver = 10746,
  PerformanceObserverEntryList = 10766,
  PerformancePaintTiming = 10795,
  PerformanceResourceTiming = 10818,
  PerformanceServerTiming = 10844,
  PerformanceTiming = 10868,
  PeriodicWave = 10886,
  PermissionStatus = 10899,
  Permissions = 10916,
  PlacesBookmark = 10928,
  PlacesBookmarkAddition = 10943,
  PlacesBookmarkChanged = 10966,
  PlacesBookmarkGuid = 10988,
  PlacesBookmarkKeyword = 11007,
  PlacesBookmarkMoved = 11029,
  PlacesBookmarkRemoved = 11049,
  PlacesBookmarkTags = 11071,
  PlacesBookmarkTime = 11090,
  PlacesBookmarkTitle = 11109,
  PlacesBookmarkUrl = 11129,
  PlacesEvent = 11147,
  PlacesEventCounts = 11159,
  PlacesFavicon = 11177,
  PlacesHistoryCleared = 11191,
  PlacesObservers = 11212,
  PlacesPurgeCaches = 11228,
  PlacesRanking = 11246,
  PlacesVisit = 11260,
  PlacesVisitRemoved = 11272,
  PlacesVisitTitle = 11291,
  PlacesWeakCallbackWrapper = 11308,
  Plugin = 11334,
  PluginArray = 11341,
  PluginCrashedEvent = 11353,
  PointerEvent = 11372,
  PopStateEvent = 11385,
  PopupBlockedEvent = 11399,
  PopupPositionedEvent = 11417,
  PositionStateEvent = 11438,
  PrecompiledScript = 11457,
  PrivateAttribution = 11475,
  ProcessMessageManager = 11494,
  ProcessingInstruction = 11516,
  ProgressEvent = 11538,
  PromiseDebugging = 11552,
  PromiseNativeHandler = 11569,
  PromiseRejectionEvent = 11590,
  PublicKeyCredential = 11612,
  PushEvent = 11632,
  PushManager = 11642,
  PushManagerImpl = 11654,
  PushMessageData = 11670,
  PushSubscription = 11686,
  PushSubscriptionChangeEvent = 11703,
  PushSubscriptionOptions = 11731,
  RTCCertificate = 11755,
  RTCDTMFSender = 11770,
  RTCDTMFToneChangeEvent = 11784,
  RTCDataChannel = 11807,
  RTCDataChannelEvent = 11822,
  RTCDtlsTransport = 11842,
  RTCEncodedAudioFrame = 11859,
  RTCEncodedVideoFrame = 11880,
  RTCIceCandidate = 11901,
  RTCIceTransport = 11917,
  RTCIdentityProviderRegistrar = 11933,
  RTCPeerConnection = 11962,
  RTCPeerConnectionIceEvent = 11980,
  RTCPeerConnectionStatic = 12006,
  RTCRtpReceiver = 12030,
  RTCRtpScriptTransform = 12045,
  RTCRtpScriptTransformer = 12067,
  RTCRtpSender = 12091,
  RTCRtpTransceiver = 12104,
  RTCSctpTransport = 12122,
  RTCSessionDescription = 12139,
  RTCStatsReport = 12161,
  RTCTrackEvent = 12176,
  RTCTransformEvent = 12190,
  RadioNodeList = 12208,
  Range = 12222,
  ReadableByteStreamController = 12228,
  ReadableStream = 12257,
  ReadableStream_AsyncIterator = 12272,
  ReadableStreamBYOBReader = 12301,
  ReadableStreamBYOBRequest = 12326,
  ReadableStreamDefaultController = 12352,
  ReadableStreamDefaultReader = 12384,
  RedirectBlockedEvent = 12412,
  Report = 12433,
  ReportBody = 12440,
  ReportingObserver = 12451,
  Request = 12469,
  ResizeObserver = 12477,
  ResizeObserverEntry = 12492,
  ResizeObserverSize = 12512,
  Response = 12531,
  SVGAElement = 12540,
  SVGAngle = 12552,
  SVGAnimateElement = 12561,
  SVGAnimateMotionElement = 12579,
  SVGAnimateTransformElement = 12603,
  SVGAnimatedAngle = 12630,
  SVGAnimatedBoolean = 12647,
  SVGAnimatedEnumeration = 12666,
  SVGAnimatedInteger = 12689,
  SVGAnimatedLength = 12708,
  SVGAnimatedLengthList = 12726,
  SVGAnimatedNumber = 12748,
  SVGAnimatedNumberList = 12766,
  SVGAnimatedPreserveAspectRatio = 12788,
  SVGAnimatedRect = 12819,
  SVGAnimatedString = 12835,
  SVGAnimatedTransformList = 12853,
  SVGAnimationElement = 12878,
  SVGCircleElement = 12898,
  SVGClipPathElement = 12915,
  SVGComponentTransferFunctionElement = 12934,
  SVGDefsElement = 12970,
  SVGDescElement = 12985,
  SVGElement = 13000,
  SVGEllipseElement = 13011,
  SVGFEBlendElement = 13029,
  SVGFEColorMatrixElement = 13047,
  SVGFEComponentTransferElement = 13071,
  SVGFECompositeElement = 13101,
  SVGFEConvolveMatrixElement = 13123,
  SVGFEDiffuseLightingElement = 13150,
  SVGFEDisplacementMapElement = 13178,
  SVGFEDistantLightElement = 13206,
  SVGFEDropShadowElement = 13231,
  SVGFEFloodElement = 13254,
  SVGFEFuncAElement = 13272,
  SVGFEFuncBElement = 13290,
  SVGFEFuncGElement = 13308,
  SVGFEFuncRElement = 13326,
  SVGFEGaussianBlurElement = 13344,
  SVGFEImageElement = 13369,
  SVGFEMergeElement = 13387,
  SVGFEMergeNodeElement = 13405,
  SVGFEMorphologyElement = 13427,
  SVGFEOffsetElement = 13450,
  SVGFEPointLightElement = 13469,
  SVGFESpecularLightingElement = 13492,
  SVGFESpotLightElement = 13521,
  SVGFETileElement = 13543,
  SVGFETurbulenceElement = 13560,
  SVGFilterElement = 13583,
  SVGForeignObjectElement = 13600,
  SVGGElement = 13624,
  SVGGeometryElement = 13636,
  SVGGradientElement = 13655,
  SVGGraphicsElement = 13674,
  SVGImageElement = 13693,
  SVGLength = 13709,
  SVGLengthList = 13719,
  SVGLineElement = 13733,
  SVGLinearGradientElement = 13748,
  SVGMPathElement = 13773,
  SVGMarkerElement = 13789,
  SVGMaskElement = 13806,
  SVGMatrix = 13821,
  SVGMetadataElement = 13831,
  SVGNumber = 13850,
  SVGNumberList = 13860,
  SVGPathElement = 13874,
  SVGPathSegment = 13889,
  SVGPatternElement = 13904,
  SVGPoint = 13922,
  SVGPointList = 13931,
  SVGPolygonElement = 13944,
  SVGPolylineElement = 13962,
  SVGPreserveAspectRatio = 13981,
  SVGRadialGradientElement = 14004,
  SVGRect = 14029,
  SVGRectElement = 14037,
  SVGSVGElement = 14052,
  SVGScriptElement = 14066,
  SVGSetElement = 14083,
  SVGStopElement = 14097,
  SVGStringList = 14112,
  SVGStyleElement = 14126,
  SVGSwitchElement = 14142,
  SVGSymbolElement = 14159,
  SVGTSpanElement = 14176,
  SVGTextContentElement = 14192,
  SVGTextElement = 14214,
  SVGTextPathElement = 14229,
  SVGTextPositioningElement = 14248,
  SVGTitleElement = 14274,
  SVGTransform = 14290,
  SVGTransformList = 14303,
  SVGUnitTypes = 14320,
  SVGUseElement = 14333,
  SVGViewElement = 14347,
  Sanitizer = 14362,
  Scheduler = 14372,
  Screen = 14382,
  ScreenLuminance = 14389,
  ScreenOrientation = 14405,
  ScriptProcessorNode = 14423,
  ScrollAreaEvent = 14443,
  SecurityPolicyViolationEvent = 14459,
  Selection = 14488,
  ServiceWorker = 14498,
  ServiceWorkerContainer = 14512,
  ServiceWorkerGlobalScope = 14535,
  ServiceWorkerRegistration = 14560,
  SessionStoreFormData = 14586,
  SessionStoreScrollData = 14607,
  SessionStoreUtils = 14630,
  ShadowRealmGlobalScope = 14648,
  ShadowRoot = 14671,
  SharedWorker = 14682,
  SharedWorkerGlobalScope = 14695,
  SimpleGestureEvent = 14719,
  SourceBuffer = 14738,
  SourceBufferList = 14751,
  SpeechGrammar = 14768,
  SpeechGrammarList = 14782,
  SpeechRecognition = 14800,
  SpeechRecognitionAlternative = 14818,
  SpeechRecognitionError = 14847,
  SpeechRecognitionEvent = 14870,
  SpeechRecognitionResult = 14893,
  SpeechRecognitionResultList = 14917,
  SpeechSynthesis = 14945,
  SpeechSynthesisErrorEvent = 14961,
  SpeechSynthesisEvent = 14987,
  SpeechSynthesisUtterance = 15008,
  SpeechSynthesisVoice = 15033,
  StaticRange = 15054,
  StereoPannerNode = 15066,
  Storage = 15083,
  StorageEvent = 15091,
  StorageManager = 15104,
  StreamFilter = 15119,
  StreamFilterDataEvent = 15132,
  StructuredCloneHolder = 15154,
  StructuredCloneTester = 15176,
  StylePropertyMap = 15198,
  StylePropertyMapReadOnly = 15215,
  StylePropertyMapReadOnly_Iterator = 15240,
  StyleSheet = 15274,
  StyleSheetApplicableStateChangeEvent = 15285,
  StyleSheetList = 15322,
  StyleSheetRemovedEvent = 15337,
  SubmitEvent = 15360,
  SubtleCrypto = 15372,
  SyncMessageSender = 15385,
  SyncReadFile = 15403,
  TCPServerSocket = 15416,
  TCPServerSocketEvent = 15432,
  TCPSocket = 15453,
  TCPSocketErrorEvent = 15463,
  TCPSocketEvent = 15483,
  TaskController = 15498,
  TaskPriorityChangeEvent = 15513,
  TaskSignal = 15537,
  Tensor = 15548,
  TestUtils = 15555,
  TestingDeprecatedInterface = 15565,
  Text = 15592,
  TextClause = 15597,
  TextDecoder = 15608,
  TextDecoderStream = 15620,
  TextEncoder = 15638,
  TextEncoderStream = 15650,
  TextEvent = 15668,
  TextMetrics = 15678,
  TextTrack = 15690,
  TextTrackCue = 15700,
  TextTrackCueList = 15713,
  TextTrackList = 15730,
  TimeEvent = 15744,
  TimeRanges = 15754,
  ToggleEvent = 15765,
  Touch = 15777,
  TouchEvent = 15783,
  TouchList = 15794,
  TrackEvent = 15804,
  TransformStream = 15815,
  TransformStreamDefaultController = 15831,
  TransitionEvent = 15864,
  TreeColumn = 15880,
  TreeColumns = 15891,
  TreeContentView = 15903,
  TreeWalker = 15919,
  TrustedHTML = 15930,
  TrustedScript = 15942,
  TrustedScriptURL = 15956,
  TrustedTypePolicy = 15973,
  TrustedTypePolicyFactory = 15991,
  UDPMessageEvent = 16016,
  UDPSocket = 16032,
  UIEvent = 16042,
  URL = 16050,
  URLPattern = 16054,
  URLSearchParams = 16065,
  URLSearchParams_Iterator = 16081,
  UniFFIPointer = 16106,
  UniFFIScaffolding = 16120,
  UserActivation = 16138,
  UserInteraction = 16153,
  UserProximityEvent = 16169,
  VRDisplay = 16188,
  VRDisplayCapabilities = 16198,
  VRDisplayEvent = 16220,
  VREyeParameters = 16235,
  VRFieldOfView = 16251,
  VRFrameData = 16265,
  VRMockController = 16277,
  VRMockDisplay = 16294,
  VRPose = 16308,
  VRServiceTest = 16315,
  VRStageParameters = 16329,
  VTTCue = 16347,
  VTTRegion = 16354,
  ValidityState = 16364,
  VideoColorSpace = 16378,
  VideoDecoder = 16394,
  VideoEncoder = 16407,
  VideoFrame = 16420,
  VideoPlaybackQuality = 16431,
  VideoTrack = 16452,
  VideoTrackList = 16463,
  ViewTransition = 16478,
  ViewTransitionTypeSet = 16493,
  VisualViewport = 16515,
  WEBGL_color_buffer_float = 16530,
  WEBGL_compressed_texture_astc = 16555,
  WEBGL_compressed_texture_etc = 16585,
  WEBGL_compressed_texture_etc1 = 16614,
  WEBGL_compressed_texture_pvrtc = 16644,
  WEBGL_compressed_texture_s3tc = 16675,
  WEBGL_compressed_texture_s3tc_srgb = 16705,
  WEBGL_debug_renderer_info = 16740,
  WEBGL_debug_shaders = 16766,
  WEBGL_depth_texture = 16786,
  WEBGL_draw_buffers = 16806,
  WEBGL_explicit_present = 16825,
  WEBGL_lose_context = 16848,
  WEBGL_provoking_vertex = 16867,
  WGSLLanguageFeatures = 16890,
  WakeLock = 16911,
  WakeLockSentinel = 16920,
  WaveShaperNode = 16937,
  WebExtensionContentScript = 16952,
  WebExtensionPolicy = 16978,
  WebGL2RenderingContext = 16997,
  WebGLActiveInfo = 17020,
  WebGLBuffer = 17036,
  WebGLContextEvent = 17048,
  WebGLFramebuffer = 17066,
  WebGLProgram = 17083,
  WebGLQuery = 17096,
  WebGLRenderbuffer = 17107,
  WebGLRenderingContext = 17125,
  WebGLSampler = 17147,
  WebGLShader = 17160,
  WebGLShaderPrecisionFormat = 17172,
  WebGLSync = 17199,
  WebGLTexture = 17209,
  WebGLTransformFeedback = 17222,
  WebGLUniformLocation = 17245,
  WebGLVertexArrayObject = 17266,
  WebKitCSSMatrix = 17289,
  WebSocket = 17305,
  WebTransport = 17315,
  WebTransportBidirectionalStream = 17328,
  WebTransportDatagramDuplexStream = 17360,
  WebTransportError = 17393,
  WebTransportReceiveStream = 17411,
  WebTransportSendStream = 17437,
  WebrtcGlobalInformation = 17460,
  WheelEvent = 17484,
  Window = 17495,
  WindowClient = 17502,
  WindowContext = 17515,
  WindowGlobalChild = 17529,
  WindowGlobalParent = 17547,
  WindowRoot = 17566,
  Worker = 17577,
  WorkerDebuggerGlobalScope = 17584,
  WorkerGlobalScope = 17610,
  WorkerLocation = 17628,
  WorkerNavigator = 17643,
  WorkerTestUtils = 17659,
  Worklet = 17675,
  WorkletGlobalScope = 17683,
  WritableStream = 17702,
  WritableStreamDefaultController = 17717,
  WritableStreamDefaultWriter = 17749,
  XMLDocument = 17777,
  XMLHttpRequest = 17789,
  XMLHttpRequestEventTarget = 17804,
  XMLHttpRequestUpload = 17830,
  XMLSerializer = 17851,
  XPathEvaluator = 17865,
  XPathExpression = 17880,
  XPathResult = 17896,
  XRBoundedReferenceSpace = 17908,
  XRFrame = 17932,
  XRInputSource = 17940,
  XRInputSourceArray = 17954,
  XRInputSourceEvent = 17973,
  XRInputSourcesChangeEvent = 17992,
  XRPose = 18018,
  XRReferenceSpace = 18025,
  XRReferenceSpaceEvent = 18042,
  XRRenderState = 18064,
  XRRigidTransform = 18078,
  XRSession = 18095,
  XRSessionEvent = 18105,
  XRSpace = 18120,
  XRSystem = 18128,
  XRView = 18137,
  XRViewerPose = 18144,
  XRViewport = 18157,
  XRWebGLLayer = 18168,
  XSLTProcessor = 18181,
  XULCommandEvent = 18195,
  XULElement = 18211,
  XULFrameElement = 18222,
  XULMenuElement = 18238,
  XULPopupElement = 18253,
  XULResizerElement = 18269,
  XULTextElement = 18287,
  XULTreeElement = 18302,
  console = 18317,
  webkitSpeechGrammar = 18325,
  webkitSpeechGrammarList = 18345,
  webkitSpeechRecognition = 18369,
  webkitURL = 18393,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
