/* THIS FILE IS AUTOGENERATED FROM HTMLFormControlsCollection.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_HTMLFORMCONTROLSCOLLECTIONBINDING_H_
#define DOM_HTMLFORMCONTROLSCOLLECTIONBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

class Element;
class HTMLFormControlsCollection;
struct NativePropertyHooks;
class OwningRadioNodeListOrElement;
class ProtoAndIfaceCache;
class RadioNodeList;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningRadioNodeListOrElement& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningRadioNodeListOrElement& aUnion);


class RadioNodeListOrElement : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eRadioNodeList,
    eElement
  };
public:
  enum class Type
  {
    eRadioNodeList = TypeOrUninit::eRadioNodeList,
    eElement = TypeOrUninit::eElement
  };

private:
  union Value
  {
    UnionMember<NonNull<mozilla::dom::RadioNodeList> > mRadioNodeList;
    UnionMember<NonNull<mozilla::dom::Element> > mElement;

  };

  TypeOrUninit mType;
  Value mValue;

  RadioNodeListOrElement(const RadioNodeListOrElement&) = delete;
  RadioNodeListOrElement& operator=(const RadioNodeListOrElement&) = delete;
public:
  explicit inline RadioNodeListOrElement()
    : mType(eUninitialized)
  {
  }

  inline ~RadioNodeListOrElement()
  {
    Uninit();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::RadioNodeList>&
  RawSetAsRadioNodeList()
  {
    if (mType == eRadioNodeList) {
      return mValue.mRadioNodeList.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eRadioNodeList;
    return mValue.mRadioNodeList.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::RadioNodeList>&
  SetAsRadioNodeList()
  {
    if (mType == eRadioNodeList) {
      return mValue.mRadioNodeList.Value();
    }
    Uninit();
    mType = eRadioNodeList;
    return mValue.mRadioNodeList.SetValue();
  }

  inline bool
  IsRadioNodeList() const
  {
    return mType == eRadioNodeList;
  }

  inline NonNull<mozilla::dom::RadioNodeList>&
  GetAsRadioNodeList()
  {
    MOZ_RELEASE_ASSERT(IsRadioNodeList(), "Wrong type!");
    return mValue.mRadioNodeList.Value();
  }

  inline mozilla::dom::RadioNodeList&
  GetAsRadioNodeList() const
  {
    MOZ_RELEASE_ASSERT(IsRadioNodeList(), "Wrong type!");
    return mValue.mRadioNodeList.Value();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Element>&
  RawSetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  [[nodiscard]] inline NonNull<mozilla::dom::Element>&
  SetAsElement()
  {
    if (mType == eElement) {
      return mValue.mElement.Value();
    }
    Uninit();
    mType = eElement;
    return mValue.mElement.SetValue();
  }

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline NonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline mozilla::dom::Element&
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eRadioNodeList: {
        DestroyRadioNodeList();
        break;
      }
      case eElement: {
        DestroyElement();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToRadioNodeList(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRadioNodeList(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyRadioNodeList()
  {
    MOZ_RELEASE_ASSERT(IsRadioNodeList(), "Wrong type!");
    mValue.mRadioNodeList.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    mValue.mElement.Destroy();
    mType = eUninitialized;
  }
};


class OwningRadioNodeListOrElement : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningRadioNodeListOrElement& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eRadioNodeList,
    eElement
  };
public:
  enum class Type
  {
    eRadioNodeList = TypeOrUninit::eRadioNodeList,
    eElement = TypeOrUninit::eElement
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<mozilla::dom::RadioNodeList> > mRadioNodeList;
    UnionMember<OwningNonNull<mozilla::dom::Element> > mElement;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningRadioNodeListOrElement()
    : mType(eUninitialized)
  {
  }

  OwningRadioNodeListOrElement(OwningRadioNodeListOrElement&& aOther);

  explicit inline OwningRadioNodeListOrElement(const OwningRadioNodeListOrElement& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningRadioNodeListOrElement()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::RadioNodeList>&
  RawSetAsRadioNodeList();

  [[nodiscard]] OwningNonNull<mozilla::dom::RadioNodeList>&
  SetAsRadioNodeList();

  inline bool
  IsRadioNodeList() const
  {
    return mType == eRadioNodeList;
  }

  inline OwningNonNull<mozilla::dom::RadioNodeList>&
  GetAsRadioNodeList()
  {
    MOZ_RELEASE_ASSERT(IsRadioNodeList(), "Wrong type!");
    return mValue.mRadioNodeList.Value();
  }

  inline OwningNonNull<mozilla::dom::RadioNodeList> const &
  GetAsRadioNodeList() const
  {
    MOZ_RELEASE_ASSERT(IsRadioNodeList(), "Wrong type!");
    return mValue.mRadioNodeList.Value();
  }

  [[nodiscard]] OwningNonNull<mozilla::dom::Element>&
  RawSetAsElement();

  [[nodiscard]] OwningNonNull<mozilla::dom::Element>&
  SetAsElement();

  inline bool
  IsElement() const
  {
    return mType == eElement;
  }

  inline OwningNonNull<mozilla::dom::Element>&
  GetAsElement()
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  inline OwningNonNull<mozilla::dom::Element> const &
  GetAsElement() const
  {
    MOZ_RELEASE_ASSERT(IsElement(), "Wrong type!");
    return mValue.mElement.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  OwningRadioNodeListOrElement&
  operator=(OwningRadioNodeListOrElement&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningRadioNodeListOrElement&
  operator=(const OwningRadioNodeListOrElement& aOther);

private:
  bool
  TrySetToRadioNodeList(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToRadioNodeList(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyRadioNodeList();

  bool
  TrySetToElement(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElement(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyElement();
};


namespace HTMLFormControlsCollection_Binding {

  typedef mozilla::dom::HTMLFormControlsCollection NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::HTMLFormControlsCollection* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::HTMLFormControlsCollection,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLFormControlsCollection,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::HTMLFormControlsCollection,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace HTMLFormControlsCollection_Binding



} // namespace mozilla::dom

#endif // DOM_HTMLFORMCONTROLSCOLLECTIONBINDING_H_
