/* THIS FILE IS AUTOGENERATED FROM Element.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_ELEMENTBINDING_H_
#define DOM_ELEMENTBINDING_H_

#include "SanitizerBinding.h"
#include "ShadowRootBinding.h"
#include "WindowBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ShadowRoot.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {
namespace dom {

struct CheckVisibilityOptionsAtoms;
class Element;
struct FocusOptionsAtoms;
struct GetHTMLOptionsAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;
struct SanitizerConfig;
struct ScrollIntoViewOptionsAtoms;
struct SetHTMLOptionsAtoms;
class ShadowRoot;
struct ShadowRootInitAtoms;

} // namespace dom
} // namespace mozilla

namespace mozilla {

namespace dom {

enum class ScrollLogicalPosition : uint8_t {
  Start,
  Center,
  End,
  Nearest,
};

namespace binding_detail {
template <> struct EnumStrings<ScrollLogicalPosition> {
  static const nsLiteralCString Values[4];
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ScrollLogicalPosition aArgument, JS::MutableHandle<JS::Value> aValue);


struct CheckVisibilityOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCheckOpacity;
  MOZ_INIT_OUTSIDE_CTOR bool mCheckVisibilityCSS;
  MOZ_INIT_OUTSIDE_CTOR bool mContentVisibilityAuto;
  MOZ_INIT_OUTSIDE_CTOR bool mFlush;
  MOZ_INIT_OUTSIDE_CTOR bool mOpacityProperty;
  MOZ_INIT_OUTSIDE_CTOR bool mVisibilityProperty;

  CheckVisibilityOptions();

  explicit inline CheckVisibilityOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CheckVisibilityOptions(CheckVisibilityOptions&& aOther) = default;

  explicit inline CheckVisibilityOptions(const CheckVisibilityOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  CheckVisibilityOptions&
  operator=(const CheckVisibilityOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, CheckVisibilityOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastCheckVisibilityOptions : public CheckVisibilityOptions
{
  inline FastCheckVisibilityOptions()
    : CheckVisibilityOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct FocusOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<bool> mFocusVisible;
  MOZ_INIT_OUTSIDE_CTOR bool mPreventScroll;

  FocusOptions();

  explicit inline FocusOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FocusOptions(FocusOptions&& aOther) = default;

  explicit inline FocusOptions(const FocusOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  FocusOptions&
  operator=(const FocusOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, FocusOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastFocusOptions : public FocusOptions
{
  inline FastFocusOptions()
    : FocusOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GetHTMLOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mSerializableShadowRoots;
  MOZ_INIT_OUTSIDE_CTOR Sequence<OwningNonNull<mozilla::dom::ShadowRoot>> mShadowRoots;

  GetHTMLOptions();

  explicit inline GetHTMLOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GetHTMLOptions(GetHTMLOptions&& aOther) = default;

  explicit inline GetHTMLOptions(const GetHTMLOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mShadowRoots, "mShadowRoots", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mShadowRoots);
  }

  GetHTMLOptions&
  operator=(const GetHTMLOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, GetHTMLOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGetHTMLOptions : public GetHTMLOptions
{
  inline FastGetHTMLOptions()
    : GetHTMLOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ScrollIntoViewOptions : public ScrollOptions
{
  MOZ_INIT_OUTSIDE_CTOR ScrollLogicalPosition mBlock;
  MOZ_INIT_OUTSIDE_CTOR ScrollLogicalPosition mInline;

  ScrollIntoViewOptions();

  explicit inline ScrollIntoViewOptions(const FastDictionaryInitializer& )
    : ScrollOptions(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ScrollIntoViewOptions(ScrollIntoViewOptions&& aOther) = default;

  explicit inline ScrollIntoViewOptions(const ScrollIntoViewOptions& aOther)
    : ScrollOptions(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ScrollIntoViewOptions&
  operator=(const ScrollIntoViewOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ScrollIntoViewOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastScrollIntoViewOptions : public ScrollIntoViewOptions
{
  inline FastScrollIntoViewOptions()
    : ScrollIntoViewOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct SetHTMLOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<SanitizerConfig> mSanitizer;

  SetHTMLOptions();

  explicit inline SetHTMLOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  SetHTMLOptions(SetHTMLOptions&& aOther) = default;

  explicit inline SetHTMLOptions(const SetHTMLOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  SetHTMLOptions&
  operator=(const SetHTMLOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, SetHTMLOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastSetHTMLOptions : public SetHTMLOptions
{
  inline FastSetHTMLOptions()
    : SetHTMLOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ShadowRootInit : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mClonable;
  MOZ_INIT_OUTSIDE_CTOR bool mDelegatesFocus;
  MOZ_INIT_OUTSIDE_CTOR ShadowRootMode mMode;
  MOZ_INIT_OUTSIDE_CTOR bool mSerializable;
  MOZ_INIT_OUTSIDE_CTOR SlotAssignmentMode mSlotAssignment;

  ShadowRootInit();

  explicit inline ShadowRootInit(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ShadowRootInit(ShadowRootInit&& aOther) = default;

  explicit inline ShadowRootInit(const ShadowRootInit& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ShadowRootInit&
  operator=(const ShadowRootInit& aOther);

private:
  static bool
  InitIds(JSContext* cx, ShadowRootInitAtoms* atomsCache);
};

namespace binding_detail {
struct FastShadowRootInit : public ShadowRootInit
{
  inline FastShadowRootInit()
    : ShadowRootInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class BooleanOrScrollIntoViewOptions : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eBoolean,
    eScrollIntoViewOptions
  };
public:
  enum class Type
  {
    eBoolean = TypeOrUninit::eBoolean,
    eScrollIntoViewOptions = TypeOrUninit::eScrollIntoViewOptions
  };

private:
  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<binding_detail::FastScrollIntoViewOptions > mScrollIntoViewOptions;

  };

  TypeOrUninit mType;
  Value mValue;

  BooleanOrScrollIntoViewOptions(const BooleanOrScrollIntoViewOptions&) = delete;
  BooleanOrScrollIntoViewOptions& operator=(const BooleanOrScrollIntoViewOptions&) = delete;
public:
  explicit inline BooleanOrScrollIntoViewOptions()
    : mType(eUninitialized)
  {
  }

  inline ~BooleanOrScrollIntoViewOptions()
  {
    Uninit();
  }

  [[nodiscard]] inline bool&
  RawSetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  [[nodiscard]] inline bool&
  SetAsBoolean()
  {
    if (mType == eBoolean) {
      return mValue.mBoolean.Value();
    }
    Uninit();
    mType = eBoolean;
    return mValue.mBoolean.SetValue();
  }

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  [[nodiscard]] inline binding_detail::FastScrollIntoViewOptions&
  RawSetAsScrollIntoViewOptions()
  {
    if (mType == eScrollIntoViewOptions) {
      return mValue.mScrollIntoViewOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eScrollIntoViewOptions;
    return mValue.mScrollIntoViewOptions.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastScrollIntoViewOptions&
  SetAsScrollIntoViewOptions()
  {
    if (mType == eScrollIntoViewOptions) {
      return mValue.mScrollIntoViewOptions.Value();
    }
    Uninit();
    mType = eScrollIntoViewOptions;
    return mValue.mScrollIntoViewOptions.SetValue();
  }

  inline bool
  IsScrollIntoViewOptions() const
  {
    return mType == eScrollIntoViewOptions;
  }

  inline binding_detail::FastScrollIntoViewOptions&
  GetAsScrollIntoViewOptions()
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  inline const ScrollIntoViewOptions&
  GetAsScrollIntoViewOptions() const
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eBoolean: {
        DestroyBoolean();
        break;
      }
      case eScrollIntoViewOptions: {
        DestroyScrollIntoViewOptions();
        break;
      }
    }
  }

private:
  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    mValue.mBoolean.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToScrollIntoViewOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToScrollIntoViewOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyScrollIntoViewOptions()
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    mValue.mScrollIntoViewOptions.Destroy();
    mType = eUninitialized;
  }
};


class OwningBooleanOrScrollIntoViewOptions : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eBoolean,
    eScrollIntoViewOptions
  };
public:
  enum class Type
  {
    eBoolean = TypeOrUninit::eBoolean,
    eScrollIntoViewOptions = TypeOrUninit::eScrollIntoViewOptions
  };

private:
  union Value
  {
    UnionMember<bool > mBoolean;
    UnionMember<ScrollIntoViewOptions > mScrollIntoViewOptions;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningBooleanOrScrollIntoViewOptions()
    : mType(eUninitialized)
  {
  }

  OwningBooleanOrScrollIntoViewOptions(OwningBooleanOrScrollIntoViewOptions&& aOther);

  explicit inline OwningBooleanOrScrollIntoViewOptions(const OwningBooleanOrScrollIntoViewOptions& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningBooleanOrScrollIntoViewOptions()
  {
    Uninit();
  }

  [[nodiscard]] bool&
  RawSetAsBoolean();

  [[nodiscard]] bool&
  SetAsBoolean();

  inline bool
  IsBoolean() const
  {
    return mType == eBoolean;
  }

  inline bool&
  GetAsBoolean()
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  inline bool const &
  GetAsBoolean() const
  {
    MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
    return mValue.mBoolean.Value();
  }

  [[nodiscard]] ScrollIntoViewOptions&
  RawSetAsScrollIntoViewOptions();

  [[nodiscard]] ScrollIntoViewOptions&
  SetAsScrollIntoViewOptions();

  inline bool
  IsScrollIntoViewOptions() const
  {
    return mType == eScrollIntoViewOptions;
  }

  inline ScrollIntoViewOptions&
  GetAsScrollIntoViewOptions()
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  inline ScrollIntoViewOptions const &
  GetAsScrollIntoViewOptions() const
  {
    MOZ_RELEASE_ASSERT(IsScrollIntoViewOptions(), "Wrong type!");
    return mValue.mScrollIntoViewOptions.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningBooleanOrScrollIntoViewOptions&
  operator=(OwningBooleanOrScrollIntoViewOptions&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningBooleanOrScrollIntoViewOptions&
  operator=(const OwningBooleanOrScrollIntoViewOptions& aOther);

private:
  bool
  TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyBoolean();

  bool
  TrySetToScrollIntoViewOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToScrollIntoViewOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyScrollIntoViewOptions();
};


namespace Element_Binding {

  typedef mozilla::dom::Element NativeType;

  bool
  CountMaybeMissingProperty(JS::Handle<JSObject*> proxy, JS::Handle<jsid> id);

  bool
  Wrap(JSContext* aCx, mozilla::dom::Element* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Element,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  JSObject*
  GetProtoObject(JSContext* aCx);

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Element,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Element,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Element_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::ScrollLogicalPosition>
{
  static constexpr dom::ScrollLogicalPosition value = dom::ScrollLogicalPosition::Nearest;

  static_assert(static_cast<uint8_t>(dom::ScrollLogicalPosition::Start) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(mozilla::ArrayLength(dom::binding_detail::EnumStrings<dom::ScrollLogicalPosition>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_ELEMENTBINDING_H_
