/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.velocity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.ParserPoolImpl;
import org.apache.velocity.runtime.resource.ResourceCacheImpl;
import org.apache.velocity.runtime.resource.ResourceManagerImpl;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.ToolManager;
import org.apache.velocity.tools.config.FactoryConfiguration;
import org.apache.velocity.tools.config.ToolConfiguration;
import org.apache.velocity.tools.config.ToolboxConfiguration;
import org.apache.velocity.tools.config.XmlFactoryConfiguration;
import org.apache.velocity.tools.generic.CollectionTool;
import org.apache.velocity.tools.generic.ComparisonDateTool;
import org.apache.velocity.tools.generic.DisplayTool;
import org.apache.velocity.tools.generic.EscapeTool;
import org.apache.velocity.tools.generic.JsonTool;
import org.apache.velocity.tools.generic.MathTool;
import org.apache.velocity.tools.generic.NumberTool;
import org.apache.velocity.tools.generic.XmlTool;
import org.mockserver.formatting.StringFormatter;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.HttpRequest;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.DTO;
import org.mockserver.templates.engine.TemplateEngine;
import org.mockserver.templates.engine.TemplateFunctions;
import org.mockserver.templates.engine.model.HttpRequestTemplateObject;
import org.mockserver.templates.engine.serializer.HttpTemplateOutputDeserializer;
import org.mockserver.templates.engine.velocity.directives.Ifnull;
import org.slf4j.event.Level;

public class VelocityTemplateEngine
implements TemplateEngine {
    private static final VelocityEngine velocityEngine;
    private static final ToolContext toolContext;
    private static ObjectMapper objectMapper;
    private final MockServerLogger mockServerLogger;
    private HttpTemplateOutputDeserializer httpTemplateOutputDeserializer;

    public VelocityTemplateEngine(MockServerLogger mockServerLogger) {
        this.mockServerLogger = mockServerLogger;
        this.httpTemplateOutputDeserializer = new HttpTemplateOutputDeserializer(mockServerLogger);
        if (objectMapper == null) {
            objectMapper = ObjectMapperFactory.createObjectMapper();
        }
    }

    @Override
    public <T> T executeTemplate(String template, HttpRequest request, Class<? extends DTO<T>> dtoClass) {
        Object result;
        try {
            JsonNode generatedObject;
            StringWriter writer;
            block5: {
                writer = new StringWriter();
                VelocityContext context = new VelocityContext((Context)toolContext);
                context.put("request", (Object)new HttpRequestTemplateObject(request));
                TemplateFunctions.BUILT_IN_FUNCTIONS.forEach((arg_0, arg_1) -> ((VelocityContext)context).put(arg_0, arg_1));
                velocityEngine.evaluate((Context)context, (Writer)writer, "VelocityResponseTemplate", template);
                generatedObject = null;
                try {
                    generatedObject = objectMapper.readTree(((Object)writer).toString());
                }
                catch (Throwable throwable) {
                    if (!MockServerLogger.isEnabled(Level.INFO)) break block5;
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("exception deserialising generated content:{}into json node for request:{}").setArguments(((Object)writer).toString(), request));
                }
            }
            if (MockServerLogger.isEnabled(Level.INFO)) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.TEMPLATE_GENERATED).setLogLevel(Level.INFO).setHttpRequest(request).setMessageFormat("generated output:{}from template:{}for request:{}").setArguments(generatedObject != null ? generatedObject : ((Object)writer).toString(), template, request));
            }
            result = this.httpTemplateOutputDeserializer.deserializer(request, ((Object)writer).toString(), dtoClass);
        }
        catch (Exception e) {
            throw new RuntimeException(StringFormatter.formatLogMessage("Exception:{}transforming template:{}for request:{}", StringUtils.isNotBlank((CharSequence)e.getMessage()) ? e.getMessage() : e.getClass().getSimpleName(), template, request), e);
        }
        return result;
    }

    static {
        Properties velocityProperties = new Properties();
        velocityProperties.put("runtime.log.log_invalid_references", "true");
        velocityProperties.put("runtime.string_interning", "true");
        velocityProperties.put("directive.foreach.max_loops", "-1");
        velocityProperties.put("directive.if.empty_check", "true");
        velocityProperties.put("directive.parse.max_depth", "10");
        velocityProperties.put("runtime.strict_mode.enable", "false");
        velocityProperties.put("context.scope_control.template", "false");
        velocityProperties.put("context.scope_control.evaluate", "false");
        velocityProperties.put("context.scope_control.foreach", "true");
        velocityProperties.put("context.scope_control.macro", "false");
        velocityProperties.put("context.scope_control.define", "false");
        velocityProperties.put("directive.set.null.allowed", "true");
        velocityProperties.put("runtime.interpolate_string_literals", "true");
        velocityProperties.put("resource.default_encoding", "UTF-8");
        velocityProperties.put("parser.pool.class", ParserPoolImpl.class.getName());
        velocityProperties.put("parser.pool.size", "50");
        velocityProperties.put("parser.space_gobbling", "lines");
        velocityProperties.put("parser.allow_hyphen_in_identifiers", "true");
        velocityProperties.put("runtime.custom_directives", Ifnull.class.getName());
        velocityProperties.put("resource.manager.class", ResourceManagerImpl.class.getName());
        velocityProperties.put("resource.manager.cache.class", ResourceCacheImpl.class.getName());
        velocityProperties.put("resource.loader.file.class", FileResourceLoader.class.getName());
        velocityEngine = new VelocityEngine();
        velocityEngine.init(velocityProperties);
        ToolManager manager = new ToolManager();
        ToolboxConfiguration applicationToolboxConfiguration = new ToolboxConfiguration();
        applicationToolboxConfiguration.setScope("application");
        ToolConfiguration collectionTool = new ToolConfiguration();
        collectionTool.setClass(CollectionTool.class.getName());
        applicationToolboxConfiguration.addTool(collectionTool);
        ToolConfiguration comparisonDateTool = new ToolConfiguration();
        comparisonDateTool.setClass(ComparisonDateTool.class.getName());
        applicationToolboxConfiguration.addTool(comparisonDateTool);
        ToolConfiguration displayTool = new ToolConfiguration();
        displayTool.setClass(DisplayTool.class.getName());
        applicationToolboxConfiguration.addTool(displayTool);
        ToolConfiguration escapeTool = new ToolConfiguration();
        escapeTool.setClass(EscapeTool.class.getName());
        applicationToolboxConfiguration.addTool(escapeTool);
        ToolConfiguration mathTool = new ToolConfiguration();
        mathTool.setClass(MathTool.class.getName());
        applicationToolboxConfiguration.addTool(mathTool);
        ToolConfiguration numberTool = new ToolConfiguration();
        numberTool.setClass(NumberTool.class.getName());
        applicationToolboxConfiguration.addTool(numberTool);
        ToolboxConfiguration requestToolboxConfiguration = new ToolboxConfiguration();
        requestToolboxConfiguration.setScope("request");
        ToolConfiguration jsonTool = new ToolConfiguration();
        jsonTool.setClass(JsonTool.class.getName());
        requestToolboxConfiguration.addTool(jsonTool);
        ToolConfiguration xmlTool = new ToolConfiguration();
        xmlTool.setClass(XmlTool.class.getName());
        requestToolboxConfiguration.addTool(xmlTool);
        XmlFactoryConfiguration xmlFactoryConfiguration = new XmlFactoryConfiguration();
        xmlFactoryConfiguration.addToolbox(applicationToolboxConfiguration);
        xmlFactoryConfiguration.addToolbox(requestToolboxConfiguration);
        manager.configure((FactoryConfiguration)xmlFactoryConfiguration);
        manager.setVelocityEngine(velocityEngine);
        toolContext = manager.createContext();
    }
}

