/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.serialization.model;

import org.mockserver.model.CookiesModifier;
import org.mockserver.model.HeadersModifier;
import org.mockserver.model.HttpRequestModifier;
import org.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import org.mockserver.model.PathModifier;
import org.mockserver.model.QueryParametersModifier;
import org.mockserver.serialization.model.CookiesModifierDTO;
import org.mockserver.serialization.model.DTO;
import org.mockserver.serialization.model.HeadersModifierDTO;
import org.mockserver.serialization.model.QueryParametersModifierDTO;

public class HttpRequestModifierDTO
extends ObjectWithReflectiveEqualsHashCodeToString
implements DTO<HttpRequestModifier> {
    private PathModifier path;
    private QueryParametersModifierDTO queryStringParameters;
    private HeadersModifierDTO headers;
    private CookiesModifierDTO cookies;

    public HttpRequestModifierDTO() {
    }

    public HttpRequestModifierDTO(HttpRequestModifier httpRequestModifier) {
        if (httpRequestModifier != null) {
            this.path = httpRequestModifier.getPath();
            this.queryStringParameters = httpRequestModifier.getQueryStringParameters() != null ? new QueryParametersModifierDTO(httpRequestModifier.getQueryStringParameters()) : null;
            this.headers = httpRequestModifier.getHeaders() != null ? new HeadersModifierDTO(httpRequestModifier.getHeaders()) : null;
            this.cookies = httpRequestModifier.getCookies() != null ? new CookiesModifierDTO(httpRequestModifier.getCookies()) : null;
        }
    }

    @Override
    public HttpRequestModifier buildObject() {
        return new HttpRequestModifier().withPath(this.path).withQueryStringParameters(this.queryStringParameters != null ? (QueryParametersModifier)this.queryStringParameters.buildObject() : null).withHeaders(this.headers != null ? (HeadersModifier)this.headers.buildObject() : null).withCookies(this.cookies != null ? (CookiesModifier)this.cookies.buildObject() : null);
    }

    public PathModifier getPath() {
        return this.path;
    }

    public HttpRequestModifierDTO setPath(PathModifier path) {
        this.path = path;
        return this;
    }

    public QueryParametersModifierDTO getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public HttpRequestModifierDTO setQueryStringParameters(QueryParametersModifierDTO queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    public HeadersModifierDTO getHeaders() {
        return this.headers;
    }

    public HttpRequestModifierDTO setHeaders(HeadersModifierDTO headers) {
        this.headers = headers;
        return this;
    }

    public CookiesModifierDTO getCookies() {
        return this.cookies;
    }

    public HttpRequestModifierDTO setCookies(CookiesModifierDTO cookies) {
        this.cookies = cookies;
        return this;
    }
}

