/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core.transformers.impl;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javassist.CtClass;
import javassist.CtPrimitiveType;

class Primitives {
    private static final Map<CtPrimitiveType, Class<?>> ct2primitiveClass = Primitives.lookupMappings();

    Primitives() {
    }

    static Class<?> getClassFor(CtPrimitiveType ctPrimitiveType) {
        return ct2primitiveClass.get(ctPrimitiveType);
    }

    private static Map<CtPrimitiveType, Class<?>> lookupMappings() {
        IdentityHashMap<CtPrimitiveType, Class> mappings = new IdentityHashMap<CtPrimitiveType, Class>(10);
        for (Object[] each : new Object[][]{{CtClass.booleanType, Boolean.TYPE}, {CtClass.byteType, Byte.TYPE}, {CtClass.charType, Character.TYPE}, {CtClass.doubleType, Double.TYPE}, {CtClass.floatType, Float.TYPE}, {CtClass.intType, Integer.TYPE}, {CtClass.longType, Long.TYPE}, {CtClass.shortType, Short.TYPE}, {CtClass.voidType, Void.TYPE}}) {
            mappings.put((CtPrimitiveType)each[0], (Class)each[1]);
        }
        return Collections.unmodifiableMap(mappings);
    }
}

