/*
 * Decompiled with CFR 0.152.
 */
package org.h2.java;

import org.h2.java.Expr;
import org.h2.java.FieldObj;
import org.h2.java.JavaParser;
import org.h2.java.Type;

class VariableExpr
implements Expr {
    Expr base;
    FieldObj field;
    String name;

    VariableExpr() {
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.field != null && "length".equals(this.field.name) && this.base != null && this.base.getType() != null && this.base.getType().arrayLevel > 0) {
            stringBuilder.append("LENGTH(");
            stringBuilder.append(this.base.toString());
            stringBuilder.append(")");
        } else {
            if (this.base != null) {
                stringBuilder.append(this.base.toString()).append("->");
            }
            if (this.field != null) {
                if (this.field.isStatic) {
                    stringBuilder.append(JavaParser.toC(this.field.declaredClass + "." + this.field.name));
                } else {
                    stringBuilder.append(this.field.name);
                }
            } else {
                stringBuilder.append(JavaParser.toC(this.name));
            }
        }
        return stringBuilder.toString();
    }

    public Type getType() {
        if (this.field == null) {
            return null;
        }
        return this.field.type;
    }
}

