/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.assertj.core.util.Lists;

public final class FieldLocation
implements Comparable<FieldLocation> {
    private final String pathToUseInRules;
    private final List<String> decomposedPath;

    public FieldLocation(List<String> path) {
        this.decomposedPath = Collections.unmodifiableList(Objects.requireNonNull(path, "path cannot be null"));
        this.pathToUseInRules = FieldLocation.pathToUseInRules(this.decomposedPath);
    }

    public FieldLocation(String s) {
        this(Lists.list(s.split("\\.")));
    }

    boolean matches(FieldLocation field) {
        return this.pathToUseInRules.equals(field.pathToUseInRules);
    }

    boolean matches(String fieldPath) {
        return this.pathToUseInRules.equals(fieldPath);
    }

    public List<String> getDecomposedPath() {
        return this.decomposedPath;
    }

    public String getPathToUseInRules() {
        return this.pathToUseInRules;
    }

    FieldLocation field(String field) {
        ArrayList<String> decomposedPathWithField = new ArrayList<String>(this.decomposedPath);
        decomposedPathWithField.add(field);
        return new FieldLocation(decomposedPathWithField);
    }

    @Override
    public int compareTo(FieldLocation other) {
        return this.pathToUseInRules.compareTo(other.pathToUseInRules);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldLocation)) {
            return false;
        }
        FieldLocation that = (FieldLocation)obj;
        return Objects.equals(this.pathToUseInRules, that.pathToUseInRules) && Objects.equals(this.decomposedPath, that.decomposedPath);
    }

    public int hashCode() {
        return Objects.hash(this.pathToUseInRules, this.decomposedPath);
    }

    public String toString() {
        return String.format("FieldLocation [pathToUseInRules=%s, decomposedPath=%s]", this.pathToUseInRules, this.decomposedPath);
    }

    public String shortDescription() {
        return this.pathToUseInRules;
    }

    private static String pathToUseInRules(List<String> path) {
        return path.stream().filter(subpath -> !subpath.startsWith("[")).collect(Collectors.joining("."));
    }

    public String getFieldName() {
        if (this.decomposedPath.isEmpty()) {
            return "";
        }
        return this.decomposedPath.get(this.decomposedPath.size() - 1);
    }

    static FieldLocation rootFieldLocation() {
        return new FieldLocation(Collections.emptyList());
    }

    public boolean hasParent(FieldLocation parent) {
        return this.pathToUseInRules.startsWith(parent.pathToUseInRules + ".");
    }

    public boolean hasChild(FieldLocation child) {
        return child.hasParent(this);
    }
}

