/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http.pathmap;

import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.PathSpecGroup;
import org.eclipse.jetty.http.pathmap.RegexPathSpec;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RegexPathSpecTest {
    public static void assertMatches(PathSpec spec, String path) {
        String msg = String.format("Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        Assertions.assertNotNull((Object)spec.matched(path), (String)msg);
    }

    public static void assertNotMatches(PathSpec spec, String path) {
        String msg = String.format("!Spec(\"%s\").matches(\"%s\")", spec.getDeclaration(), path);
        Assertions.assertNull((Object)spec.matched(path), (String)msg);
    }

    @Test
    public void testExactSpec() {
        RegexPathSpec spec = new RegexPathSpec("^/a$");
        Assertions.assertEquals((Object)"^/a$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.EXACT, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a/");
    }

    @Test
    public void testMiddleSpec() {
        RegexPathSpec spec = new RegexPathSpec("^/rest/([^/]*)/list$");
        Assertions.assertEquals((Object)"^/rest/([^/]*)/list$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/rest/([^/]*)/list$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)3, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/api/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/1.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/2.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/accounts/list");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/admin/delete");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/list");
    }

    @Test
    public void testPathInfo() {
        RegexPathSpec spec = new RegexPathSpec("^/test(/.*)?$");
        Assertions.assertTrue((boolean)spec.matches("/test/info"));
        MatcherAssert.assertThat((Object)spec.getPathMatch("/test/info"), (Matcher)Matchers.equalTo((Object)"/test"));
        MatcherAssert.assertThat((Object)spec.getPathInfo("/test/info"), (Matcher)Matchers.equalTo((Object)"/info"));
        spec = new RegexPathSpec("^/[Tt]est(/.*)?$");
        Assertions.assertTrue((boolean)spec.matches("/test/info"));
        MatcherAssert.assertThat((Object)spec.getPathMatch("/test/info"), (Matcher)Matchers.equalTo((Object)"/test/info"));
        MatcherAssert.assertThat((Object)spec.getPathInfo("/test/info"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testMiddleSpecNoGrouping() {
        RegexPathSpec spec = new RegexPathSpec("^/rest/[^/]+/list$");
        Assertions.assertEquals((Object)"^/rest/[^/]+/list$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/rest/[^/]+/list$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)3, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.MIDDLE_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/api/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/1.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/2.0/list");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/rest/accounts/list");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/admin/delete");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/rest/list");
    }

    @Test
    public void testPrefixSpec() {
        RegexPathSpec spec = new RegexPathSpec("^/a/(.*)$");
        Assertions.assertEquals((Object)"^/a/(.*)$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/a/(.*)$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.PREFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b/c/d/e");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
    }

    @Test
    public void testSuffixSpecTraditional() {
        RegexPathSpec spec = new RegexPathSpec("^(.*).do$");
        Assertions.assertEquals((Object)"^(.*).do$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^(.*).do$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)0, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.SUFFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b/c.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/abcde.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/abc/efg.do");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb.do/more");
        MatcherAssert.assertThat((Object)spec.getPathMatch("/a/b/c.do"), (Matcher)Matchers.equalTo((Object)"/a/b/c.do"));
        MatcherAssert.assertThat((Object)spec.getPathInfo("/a/b/c.do"), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testSuffixSpecGlobish() {
        RegexPathSpec spec = new RegexPathSpec("^/[Hh]ello");
        Assertions.assertEquals((Object)"^/[Hh]ello", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^/[Hh]ello", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)1, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.SUFFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/hello");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/Hello");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/Hello/World");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/aa/bb.do/more");
        MatcherAssert.assertThat((Object)spec.getPathMatch("/hello"), (Matcher)Matchers.equalTo((Object)"/hello"));
        MatcherAssert.assertThat((Object)spec.getPathInfo("/hello"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)spec.getPathMatch("/Hello"), (Matcher)Matchers.equalTo((Object)"/Hello"));
        MatcherAssert.assertThat((Object)spec.getPathInfo("/Hello"), (Matcher)Matchers.nullValue());
        MatchedPath matchedPath = spec.matched("/hello");
        MatcherAssert.assertThat((Object)matchedPath.getPathMatch(), (Matcher)Matchers.equalTo((Object)"/hello"));
        MatcherAssert.assertThat((Object)matchedPath.getPathInfo(), (Matcher)Matchers.nullValue());
        matchedPath = spec.matched("/Hello");
        MatcherAssert.assertThat((Object)matchedPath.getPathMatch(), (Matcher)Matchers.equalTo((Object)"/Hello"));
        MatcherAssert.assertThat((Object)matchedPath.getPathInfo(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testSuffixSpecMiddle() {
        RegexPathSpec spec = new RegexPathSpec("^.*/middle/.*$");
        Assertions.assertEquals((Object)"^.*/middle/.*$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^.*/middle/.*$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.SUFFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/middle/c.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b/c/d/middle/e/f");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/middle/");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a.do");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a/middle");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/middle");
    }

    @Test
    public void testSuffixSpecMiddleWithGroupings() {
        RegexPathSpec spec = new RegexPathSpec("^(.*)/middle/(.*)$");
        Assertions.assertEquals((Object)"^(.*)/middle/(.*)$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^(.*)/middle/(.*)$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.SUFFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/middle/c.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b/c/d/middle/e/f");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/middle/");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a.do");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a/middle");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/middle");
    }

    @Test
    public void testNamedRegexGroup() {
        RegexPathSpec spec = new RegexPathSpec("^(?<name>(.*)/middle/)(?<info>.*)$");
        Assertions.assertEquals((Object)"^(?<name>(.*)/middle/)(?<info>.*)$", (Object)spec.getDeclaration(), (String)"Spec.pathSpec");
        Assertions.assertEquals((Object)"^(?<name>(.*)/middle/)(?<info>.*)$", (Object)spec.getPattern().pattern(), (String)"Spec.pattern");
        Assertions.assertEquals((int)2, (int)spec.getPathDepth(), (String)"Spec.pathDepth");
        Assertions.assertEquals((Object)PathSpecGroup.SUFFIX_GLOB, (Object)spec.getGroup(), (String)"Spec.group");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/middle/c.do");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/a/b/c/d/middle/e/f");
        RegexPathSpecTest.assertMatches((PathSpec)spec, "/middle/");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a.do");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/a/middle");
        RegexPathSpecTest.assertNotMatches((PathSpec)spec, "/middle");
        MatchedPath matchedPath = spec.matched("/a/middle/c.do");
        MatcherAssert.assertThat((Object)matchedPath.getPathMatch(), (Matcher)Matchers.is((Object)"/a/middle/"));
        MatcherAssert.assertThat((Object)matchedPath.getPathInfo(), (Matcher)Matchers.is((Object)"c.do"));
    }

    @Test
    public void testEquals() {
        MatcherAssert.assertThat((Object)new RegexPathSpec("^(.*).do$"), (Matcher)Matchers.equalTo((Object)new RegexPathSpec("^(.*).do$")));
        MatcherAssert.assertThat((Object)new RegexPathSpec("/foo"), (Matcher)Matchers.equalTo((Object)new RegexPathSpec("/foo")));
        MatcherAssert.assertThat((Object)new RegexPathSpec("^(.*).do$"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new RegexPathSpec("^(.*).gz$"))));
        MatcherAssert.assertThat((Object)new RegexPathSpec("^(.*).do$"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new RegexPathSpec("^.*.do$"))));
        MatcherAssert.assertThat((Object)new RegexPathSpec("/foo"), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)new ServletPathSpec("/foo"))));
    }
}

