/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.tests.utils.impl;

import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.Set;
import org.powermock.tests.utils.TestClassesExtractor;

public abstract class AbstractTestClassExtractor
implements TestClassesExtractor {
    @Override
    public final String[] getTestClasses(AnnotatedElement element) {
        HashSet<String> classesToPrepareForTest = new HashSet<String>();
        if (element instanceof Class) {
            Class classToInvestigate = (Class)element;
            for (classToInvestigate = classToInvestigate.getSuperclass(); classToInvestigate != null && !classToInvestigate.equals(Object.class); classToInvestigate = classToInvestigate.getSuperclass()) {
                this.extractClassesAndAddThemToList(classToInvestigate, classesToPrepareForTest);
            }
        }
        this.extractClassesAndAddThemToList(element, classesToPrepareForTest);
        return classesToPrepareForTest.toArray(new String[classesToPrepareForTest.size()]);
    }

    private void extractClassesAndAddThemToList(AnnotatedElement elementToExtractClassFrom, Set<String> classesToPrepareForTest) {
        String[] classesToModify = this.getClassesToModify(elementToExtractClassFrom);
        if (classesToModify != null) {
            for (String className : classesToModify) {
                classesToPrepareForTest.add(className);
            }
        }
    }

    protected abstract String[] getClassesToModify(AnnotatedElement var1);

    @Override
    public boolean isPrepared(AnnotatedElement element, String fullyQualifiedClassName) {
        if (fullyQualifiedClassName == null) {
            throw new IllegalArgumentException("fullyQualifiedClassName cannot be null.");
        }
        String[] testClasses = this.getTestClasses(element);
        if (testClasses != null) {
            for (String className : testClasses) {
                if (!className.equals(fullyQualifiedClassName)) continue;
                return true;
            }
        }
        return false;
    }
}

