/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import antlr.collections.AST;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.Map;
import java.util.Set;

public class EqualsHashCodeCheck
extends AbstractCheck {
    public static final String MSG_KEY = "equals.noHashCode";
    private final Map<DetailAST, DetailAST> objBlockEquals = Maps.newHashMap();
    private final Set<DetailAST> objBlockWithHashCode = Sets.newHashSet();

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{9};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.objBlockEquals.clear();
        this.objBlockWithHashCode.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST modifiers = ast.getFirstChild();
        DetailAST type = ast.findFirstToken(13);
        DetailAST methodName = ast.findFirstToken(58);
        DetailAST parameters = ast.findFirstToken(20);
        if (type.getFirstChild().getType() == 50 && "equals".equals(methodName.getText()) && modifiers.branchContains(62) && parameters.getChildCount() == 1 && EqualsHashCodeCheck.isObjectParam((AST)parameters.getFirstChild())) {
            this.objBlockEquals.put(ast.getParent(), ast);
        } else if (type.getFirstChild().getType() == 54 && "hashCode".equals(methodName.getText()) && modifiers.branchContains(62) && parameters.getFirstChild() == null) {
            this.objBlockWithHashCode.add(ast.getParent());
        }
    }

    private static boolean isObjectParam(AST firstChild) {
        AST modifiers = firstChild.getFirstChild();
        AST type = modifiers.getNextSibling();
        switch (type.getFirstChild().getType()) {
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return false;
            }
        }
        return true;
    }

    @Override
    public void finishTree(DetailAST rootAST) {
        for (Map.Entry<DetailAST, DetailAST> detailASTDetailASTEntry : this.objBlockEquals.entrySet()) {
            if (this.objBlockWithHashCode.contains((Object)detailASTDetailASTEntry.getKey())) continue;
            DetailAST equalsAST = detailASTDetailASTEntry.getValue();
            this.log(equalsAST.getLineNo(), equalsAST.getColumnNo(), MSG_KEY, new Object[0]);
        }
        this.objBlockEquals.clear();
        this.objBlockWithHashCode.clear();
    }
}

