/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AbstractLoader;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class ConfigurationLoader {
    private static final Log LOG = LogFactory.getLog(ConfigurationLoader.class);
    private static final String DTD_PUBLIC_ID_1_0 = "-//Puppy Crawl//DTD Check Configuration 1.0//EN";
    private static final String DTD_RESOURCE_NAME_1_0 = "com/puppycrawl/tools/checkstyle/configuration_1_0.dtd";
    private static final String DTD_PUBLIC_ID_1_1 = "-//Puppy Crawl//DTD Check Configuration 1.1//EN";
    private static final String DTD_RESOURCE_NAME_1_1 = "com/puppycrawl/tools/checkstyle/configuration_1_1.dtd";
    private static final String DTD_PUBLIC_ID_1_2 = "-//Puppy Crawl//DTD Check Configuration 1.2//EN";
    private static final String DTD_RESOURCE_NAME_1_2 = "com/puppycrawl/tools/checkstyle/configuration_1_2.dtd";
    private static final String DTD_PUBLIC_ID_1_3 = "-//Puppy Crawl//DTD Check Configuration 1.3//EN";
    private static final String DTD_RESOURCE_NAME_1_3 = "com/puppycrawl/tools/checkstyle/configuration_1_3.dtd";
    private static final String UNABLE_TO_PARSE_EXCEPTION_PREFIX = "unable to parse configuration stream";
    private static final char DOLLAR_SIGN = '$';
    private final InternalLoader saxHandler;
    private final PropertyResolver overridePropsResolver;
    private final Deque<DefaultConfiguration> configStack = new ArrayDeque<DefaultConfiguration>();
    private final boolean omitIgnoredModules;
    private Configuration configuration;

    private ConfigurationLoader(PropertyResolver overrideProps, boolean omitIgnoredModules) throws ParserConfigurationException, SAXException {
        this.saxHandler = new InternalLoader();
        this.overridePropsResolver = overrideProps;
        this.omitIgnoredModules = omitIgnoredModules;
    }

    private static Map<String, String> createIdToResourceNameMap() {
        HashMap map = Maps.newHashMap();
        map.put(DTD_PUBLIC_ID_1_0, DTD_RESOURCE_NAME_1_0);
        map.put(DTD_PUBLIC_ID_1_1, DTD_RESOURCE_NAME_1_1);
        map.put(DTD_PUBLIC_ID_1_2, DTD_RESOURCE_NAME_1_2);
        map.put(DTD_PUBLIC_ID_1_3, DTD_RESOURCE_NAME_1_3);
        return map;
    }

    private void parseInputSource(InputSource source) throws IOException, SAXException {
        this.saxHandler.parseInputSource(source);
    }

    public static Configuration loadConfiguration(String config, PropertyResolver overridePropsResolver) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration(config, overridePropsResolver, false);
    }

    public static Configuration loadConfiguration(String config, PropertyResolver overridePropsResolver, boolean omitIgnoredModules) throws CheckstyleException {
        URI uri = CommonUtils.getUriByFilename(config);
        InputSource source = new InputSource(uri.toString());
        return ConfigurationLoader.loadConfiguration(source, overridePropsResolver, omitIgnoredModules);
    }

    @Deprecated
    public static Configuration loadConfiguration(InputStream configStream, PropertyResolver overridePropsResolver, boolean omitIgnoredModules) throws CheckstyleException {
        return ConfigurationLoader.loadConfiguration(new InputSource(configStream), overridePropsResolver, omitIgnoredModules);
    }

    public static Configuration loadConfiguration(InputSource configSource, PropertyResolver overridePropsResolver, boolean omitIgnoredModules) throws CheckstyleException {
        try {
            ConfigurationLoader loader = new ConfigurationLoader(overridePropsResolver, omitIgnoredModules);
            loader.parseInputSource(configSource);
            return loader.configuration;
        }
        catch (SAXParseException ex) {
            String message = String.format(Locale.ROOT, "%s - %s:%s:%s", UNABLE_TO_PARSE_EXCEPTION_PREFIX, ex.getMessage(), ex.getLineNumber(), ex.getColumnNumber());
            throw new CheckstyleException(message, ex);
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new CheckstyleException(UNABLE_TO_PARSE_EXCEPTION_PREFIX, ex);
        }
    }

    private static String replaceProperties(String value, PropertyResolver props, String defaultValue) throws CheckstyleException {
        if (value == null) {
            return null;
        }
        ArrayList fragments = Lists.newArrayList();
        ArrayList propertyRefs = Lists.newArrayList();
        ConfigurationLoader.parsePropertyString(value, fragments, propertyRefs);
        StringBuilder sb = new StringBuilder();
        Iterator fragmentsIterator = fragments.iterator();
        Iterator propertyRefsIterator = propertyRefs.iterator();
        while (fragmentsIterator.hasNext()) {
            String propertyName;
            String fragment = (String)fragmentsIterator.next();
            if (fragment == null && (fragment = props.resolve(propertyName = (String)propertyRefsIterator.next())) == null) {
                if (defaultValue != null) {
                    return defaultValue;
                }
                throw new CheckstyleException("Property ${" + propertyName + "} has not been set");
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    private static void parsePropertyString(String value, List<String> fragments, List<String> propertyRefs) throws CheckstyleException {
        int prev = 0;
        int pos = value.indexOf(36, prev);
        while (pos >= 0) {
            if (pos > 0) {
                fragments.add(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.add(String.valueOf('$'));
                prev = pos + 1;
            } else if (value.charAt(pos + 1) == '{') {
                int endName = value.indexOf(125, pos);
                if (endName < 0) {
                    throw new CheckstyleException("Syntax error in property: " + value);
                }
                String propertyName = value.substring(pos + 2, endName);
                fragments.add(null);
                propertyRefs.add(propertyName);
                prev = endName + 1;
            } else if (value.charAt(pos + 1) == '$') {
                fragments.add(String.valueOf('$'));
                prev = pos + 2;
            } else {
                fragments.add(value.substring(pos, pos + 2));
                prev = pos + 2;
            }
            pos = value.indexOf(36, prev);
        }
        if (prev < value.length()) {
            fragments.add(value.substring(prev));
        }
    }

    private final class InternalLoader
    extends AbstractLoader {
        private static final String MODULE = "module";
        private static final String NAME = "name";
        private static final String PROPERTY = "property";
        private static final String VALUE = "value";
        private static final String DEFAULT = "default";
        private static final String SEVERITY = "severity";
        private static final String MESSAGE = "message";
        private static final String METADATA = "metadata";
        private static final String KEY = "key";

        InternalLoader() throws SAXException, ParserConfigurationException {
            super(ConfigurationLoader.createIdToResourceNameMap());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(MODULE)) {
                String name = attributes.getValue(NAME);
                DefaultConfiguration conf = new DefaultConfiguration(name);
                if (ConfigurationLoader.this.configuration == null) {
                    ConfigurationLoader.this.configuration = conf;
                }
                if (!ConfigurationLoader.this.configStack.isEmpty()) {
                    DefaultConfiguration top = (DefaultConfiguration)ConfigurationLoader.this.configStack.peek();
                    top.addChild(conf);
                }
                ConfigurationLoader.this.configStack.push(conf);
            } else if (qName.equals(PROPERTY)) {
                String value;
                try {
                    value = ConfigurationLoader.replaceProperties(attributes.getValue(VALUE), ConfigurationLoader.this.overridePropsResolver, attributes.getValue(DEFAULT));
                }
                catch (CheckstyleException ex) {
                    throw new SAXException(ex);
                }
                String name = attributes.getValue(NAME);
                DefaultConfiguration top = (DefaultConfiguration)ConfigurationLoader.this.configStack.peek();
                top.addAttribute(name, value);
            } else if (qName.equals(MESSAGE)) {
                String key = attributes.getValue(KEY);
                String value = attributes.getValue(VALUE);
                DefaultConfiguration top = (DefaultConfiguration)ConfigurationLoader.this.configStack.peek();
                top.addMessage(key, value);
            } else if (!qName.equals(METADATA)) {
                throw new IllegalStateException("Unknown name:" + qName + ".");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(MODULE)) {
                boolean omitModule;
                Configuration recentModule = (Configuration)ConfigurationLoader.this.configStack.pop();
                SeverityLevel level = null;
                try {
                    String severity = recentModule.getAttribute(SEVERITY);
                    level = SeverityLevel.getInstance(severity);
                }
                catch (CheckstyleException ex) {
                    LOG.debug((Object)"Severity not set, ignoring exception", (Throwable)ex);
                }
                boolean bl = omitModule = ConfigurationLoader.this.omitIgnoredModules && level == SeverityLevel.IGNORE;
                if (omitModule && !ConfigurationLoader.this.configStack.isEmpty()) {
                    DefaultConfiguration parentModule = (DefaultConfiguration)ConfigurationLoader.this.configStack.peek();
                    parentModule.removeChild(recentModule);
                }
            }
        }
    }
}

