/*
 * Decompiled with CFR 0.152.
 */
package org.torproject.descriptor.onionperf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class TorperfResultsBuilder {
    private List<String> errorCodeParts = null;
    private final SortedMap<String, String> keyValuePairs = new TreeMap<String, String>();

    void addErrorCodePart(String errorCodePart) {
        if (null == this.errorCodeParts) {
            this.errorCodeParts = new ArrayList<String>();
        }
        this.errorCodeParts.add(errorCodePart);
    }

    void addString(String key, String stringValue) {
        if (null != stringValue) {
            this.keyValuePairs.put(key, stringValue);
        }
    }

    void addInteger(String key, Integer integerValue) {
        if (null != integerValue) {
            this.keyValuePairs.put(key, String.valueOf(integerValue));
        }
    }

    void addDouble(String key, Double doubleValue) {
        if (null != doubleValue) {
            this.keyValuePairs.put(key, String.valueOf(doubleValue));
        }
    }

    void addTimestamp(String key, Double unixTsStart, Double elapsedSeconds) {
        if (null != unixTsStart) {
            if (null != elapsedSeconds) {
                this.keyValuePairs.put(key, String.format("%.2f", unixTsStart + elapsedSeconds));
            } else {
                this.keyValuePairs.put(key, String.format("%.2f", unixTsStart));
            }
        }
    }

    void addTimestamp(String key, Double unixTsStart, String elapsedMicroseconds) {
        if (null != unixTsStart && unixTsStart >= 0.0 && null != elapsedMicroseconds && !elapsedMicroseconds.startsWith("-")) {
            double elapsedSeconds = Double.parseDouble(elapsedMicroseconds) / 1000000.0;
            this.addTimestamp(key, unixTsStart, elapsedSeconds);
        }
    }

    String build() {
        StringBuilder result = new StringBuilder();
        result.append("@type torperf 1.1\r\n");
        ArrayList<String> torperfResultsParts = new ArrayList<String>();
        if (null != this.errorCodeParts) {
            String errorCode = String.join((CharSequence)"/", this.errorCodeParts);
            this.addString("ERRORCODE", errorCode);
        }
        for (Map.Entry<String, String> keyValuePairsEntry : this.keyValuePairs.entrySet()) {
            torperfResultsParts.add(String.format("%s=%s", keyValuePairsEntry.getKey(), keyValuePairsEntry.getValue()));
        }
        result.append(String.join((CharSequence)" ", torperfResultsParts)).append("\r\n");
        return result.toString();
    }
}

